/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;

abstract class ExecutionVertexShuttle {
    protected Stack<EVNode> parents = new Stack();

    ExecutionVertexShuttle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Query<?> traverse(Query<?> query) {
        try {
            this.parents.push(new EVNode(query, null));
            if (!this.mayTraverseQuery(query)) {
                Query<?> query2 = query;
                return query2;
            }
            if (query instanceof BaseQuery) {
                DataSource newDataSource;
                BaseQuery baseQuery = (BaseQuery)query;
                DataSource oldDataSource = baseQuery.getDataSource();
                if (oldDataSource != (newDataSource = this.traverse(oldDataSource, null))) {
                    query = baseQuery.withDataSource(newDataSource);
                }
            } else {
                throw DruidException.defensive("Can't traverse a query[%s]!", query);
            }
            Query<?> query3 = this.visitQuery(query);
            return query3;
        }
        finally {
            this.parents.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataSource traverse(DataSource dataSource, Integer index) {
        try {
            this.parents.push(new EVNode(dataSource, index));
            boolean traverse = this.mayTraverseDataSource(this.parents.peek());
            if (dataSource instanceof QueryDataSource) {
                Query<?> newQuery;
                Object oldQuery;
                QueryDataSource queryDataSource = (QueryDataSource)dataSource;
                if (traverse && (oldQuery = queryDataSource.getQuery()) != (newQuery = this.traverse((Query<?>)oldQuery))) {
                    dataSource = new QueryDataSource(newQuery);
                }
                oldQuery = this.visit(dataSource, !traverse);
                return oldQuery;
            }
            List<DataSource> children = dataSource.getChildren();
            ArrayList<DataSource> newChildren = new ArrayList<DataSource>();
            boolean changed = false;
            if (traverse) {
                for (int i = 0; i < children.size(); ++i) {
                    DataSource oldDS = children.get(i);
                    DataSource newDS = this.traverse(oldDS, i);
                    newChildren.add(newDS);
                    changed |= oldDS != newDS;
                }
            }
            DataSource newDataSource = changed ? dataSource.withChildren(newChildren) : dataSource;
            DataSource dataSource2 = this.visit(newDataSource, !traverse);
            return dataSource2;
        }
        finally {
            this.parents.pop();
        }
    }

    protected abstract boolean mayTraverseQuery(Query<?> var1);

    protected abstract boolean mayTraverseDataSource(EVNode var1);

    protected abstract DataSource visit(DataSource var1, boolean var2);

    protected abstract Query<?> visitQuery(Query<?> var1);

    static class EVNode {
        final DataSource dataSource;
        final Query<?> query;
        final Integer index;

        EVNode(DataSource dataSource, Integer index) {
            this.dataSource = dataSource;
            this.query = null;
            this.index = index;
        }

        EVNode(Query<?> query, Integer index) {
            this.dataSource = null;
            this.query = query;
            this.index = index;
        }

        public boolean isQuery() {
            return this.query != null;
        }

        public Query<?> getQuery() {
            Preconditions.checkNotNull(this.query, (Object)"query is null!");
            return this.query;
        }
    }
}

