/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryExecutor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.Interval;

public abstract class SearchStrategy {
    protected final Filter filter;
    protected final Interval interval;

    protected SearchStrategy(SearchQuery query) {
        this.filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimensionsFilter()));
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", intervals);
        }
        this.interval = intervals.get(0);
    }

    public abstract List<SearchQueryExecutor> getExecutionPlan(SearchQuery var1, Segment var2);

    static List<DimensionSpec> getDimsToSearch(Segment segment, List<DimensionSpec> dimensions) {
        if (dimensions == null || dimensions.isEmpty()) {
            LinkedHashSet<String> dims = new LinkedHashSet<String>();
            QueryableIndex index = segment.as(QueryableIndex.class);
            if (index != null) {
                for (String dim : index.getAvailableDimensions()) {
                    dims.add(dim);
                }
            } else {
                PhysicalSegmentInspector segmentInspector = segment.as(PhysicalSegmentInspector.class);
                Metadata metadata = segmentInspector != null ? segmentInspector.getMetadata() : null;
                HashSet<String> ignore = new HashSet<String>();
                ignore.add("__time");
                if (metadata != null && metadata.getAggregators() != null) {
                    for (AggregatorFactory factory : metadata.getAggregators()) {
                        ignore.add(factory.getName());
                    }
                }
                RowSignature rowSignature = Objects.requireNonNull(segment.as(CursorFactory.class)).getRowSignature();
                for (String columnName : rowSignature.getColumnNames()) {
                    if (ignore.contains(columnName)) continue;
                    dims.add(columnName);
                }
            }
            return ImmutableList.copyOf((Iterable)Iterables.transform(dims, Druids.DIMENSION_IDENTITY));
        }
        return dimensions;
    }
}

