/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntList;

public class IntListUtils {
    private IntListUtils() {
    }

    public static IntList fromTo(int from, int to) {
        Preconditions.checkArgument((from <= to ? 1 : 0) != 0);
        return new RangeIntList(from, to);
    }

    private static final class RangeIntList
    extends AbstractIntList {
        private final int start;
        private final int size;

        RangeIntList(int start, int end) {
            this.start = start;
            this.size = end - start;
        }

        public int getInt(int index) {
            Preconditions.checkElementIndex((int)index, (int)this.size);
            return this.start + index;
        }

        public int size() {
            return this.size;
        }
    }
}

