/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class RemapVectorColumnSelectorFactory
implements VectorColumnSelectorFactory {
    private final VectorColumnSelectorFactory delegate;
    private final Map<String, String> remap;

    public RemapVectorColumnSelectorFactory(VectorColumnSelectorFactory delegate, Map<String, String> remap) {
        this.delegate = delegate;
        this.remap = remap;
    }

    @Override
    public ReadableVectorInspector getReadableVectorInspector() {
        return this.delegate.getReadableVectorInspector();
    }

    @Override
    public int getMaxVectorSize() {
        return this.delegate.getMaxVectorSize();
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
        DimensionSpec remapDimensionSpec = dimensionSpec.withDimension(this.remap.getOrDefault(dimensionSpec.getDimension(), dimensionSpec.getDimension()));
        return this.delegate.makeSingleValueDimensionSelector(remapDimensionSpec);
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
        DimensionSpec remapDimensionSpec = dimensionSpec.withDimension(this.remap.getOrDefault(dimensionSpec.getDimension(), dimensionSpec.getDimension()));
        return this.delegate.makeMultiValueDimensionSelector(remapDimensionSpec);
    }

    @Override
    public VectorValueSelector makeValueSelector(String column) {
        return this.delegate.makeValueSelector(this.remap.getOrDefault(column, column));
    }

    @Override
    public VectorObjectSelector makeObjectSelector(String column) {
        return this.delegate.makeObjectSelector(this.remap.getOrDefault(column, column));
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.delegate.getColumnCapabilities(this.remap.getOrDefault(column, column));
    }

    @Override
    @Nullable
    public ExpressionType getType(String name) {
        return this.delegate.getType(this.remap.getOrDefault(name, name));
    }

    @Override
    public GroupByVectorColumnSelector makeGroupByVectorColumnSelector(String column, DeferExpressionDimensions deferExpressionDimensions) {
        return this.delegate.makeGroupByVectorColumnSelector(this.remap.getOrDefault(column, column), deferExpressionDimensions);
    }
}

