/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.jackson.CommaListJoinDeserializer;
import org.apache.druid.jackson.CommaListJoinSerializer;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.PruneLastCompactionState;
import org.apache.druid.timeline.PruneLoadSpec;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class DataSegment
implements Comparable<DataSegment>,
Overshadowable<DataSegment> {
    public static final String TOMBSTONE_LOADSPEC_TYPE = "tombstone";
    private static final Interner<String> STRING_INTERNER = Interners.newWeakInterner();
    private static final Interner<List<String>> DIMENSIONS_INTERNER = Interners.newWeakInterner();
    private static final Interner<List<String>> METRICS_INTERNER = Interners.newWeakInterner();
    private static final Interner<List<String>> PROJECTIONS_INTERNER = Interners.newWeakInterner();
    private static final Interner<CompactionState> COMPACTION_STATE_INTERNER = Interners.newWeakInterner();
    private static final Map<String, Object> PRUNED_LOAD_SPEC = ImmutableMap.of((Object)"load spec is pruned, because it's not needed on Brokers, but eats a lot of heap space", (Object)"");
    private final Integer binaryVersion;
    private final SegmentId id;
    @Nullable
    private final Map<String, Object> loadSpec;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final List<String> projections;
    private final ShardSpec shardSpec;
    @Nullable
    private final CompactionState lastCompactionState;
    private final long size;

    @Deprecated
    public DataSegment(String dataSource, Interval interval, String version, Map<String, Object> loadSpec, List<String> dimensions, List<String> metrics, ShardSpec shardSpec, Integer binaryVersion, long size) {
        this(dataSource, interval, version, loadSpec, dimensions, metrics, null, shardSpec, null, binaryVersion, size, PruneSpecsHolder.DEFAULT);
    }

    @Deprecated
    public DataSegment(String dataSource, Interval interval, String version, Map<String, Object> loadSpec, List<String> dimensions, List<String> metrics, ShardSpec shardSpec, @Nullable CompactionState lastCompactionState, Integer binaryVersion, long size) {
        this(dataSource, interval, version, loadSpec, dimensions, metrics, null, shardSpec, lastCompactionState, binaryVersion, size, PruneSpecsHolder.DEFAULT);
    }

    @JsonCreator
    private DataSegment(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") String interval, @JsonProperty(value="version") String version, @JsonProperty(value="loadSpec") @Nullable Map<String, Object> loadSpec, @JsonProperty(value="dimensions") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> dimensions, @JsonProperty(value="metrics") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> metrics, @JsonProperty(value="projections") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> projections, @JsonProperty(value="shardSpec") @Nullable ShardSpec shardSpec, @JsonProperty(value="lastCompactionState") @Nullable CompactionState lastCompactionState, @JsonProperty(value="binaryVersion") Integer binaryVersion, @JsonProperty(value="size") long size, @JacksonInject PruneSpecsHolder pruneSpecsHolder) {
        this(dataSource, Intervals.fromString(interval), version, loadSpec, dimensions, metrics, projections, shardSpec, lastCompactionState, binaryVersion, size, pruneSpecsHolder);
    }

    public DataSegment(String dataSource, Interval interval, String version, @Nullable Map<String, Object> loadSpec, @Nullable List<String> dimensions, @Nullable List<String> metrics, @Nullable List<String> projections, @Nullable ShardSpec shardSpec, @Nullable CompactionState lastCompactionState, Integer binaryVersion, long size, PruneSpecsHolder pruneSpecsHolder) {
        this.id = SegmentId.of(dataSource, interval, version, shardSpec);
        this.loadSpec = pruneSpecsHolder.pruneLoadSpec ? PRUNED_LOAD_SPEC : DataSegment.prepareLoadSpec(loadSpec);
        this.dimensions = dimensions == null ? ImmutableList.of() : DataSegment.prepareWithInterner(dimensions, DIMENSIONS_INTERNER);
        this.metrics = metrics == null ? ImmutableList.of() : DataSegment.prepareWithInterner(metrics, METRICS_INTERNER);
        this.projections = projections == null ? null : DataSegment.prepareWithInterner(projections, PROJECTIONS_INTERNER);
        this.shardSpec = shardSpec == null ? new NumberedShardSpec(0, 1) : shardSpec;
        this.lastCompactionState = pruneSpecsHolder.pruneLastCompactionState ? null : DataSegment.prepareCompactionState(lastCompactionState);
        this.binaryVersion = binaryVersion;
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0);
        this.size = size;
    }

    @JsonProperty
    public String getDataSource() {
        return this.id.getDataSource();
    }

    @JsonProperty
    public Interval getInterval() {
        return this.id.getInterval();
    }

    @Nullable
    @JsonProperty
    public Map<String, Object> getLoadSpec() {
        return this.loadSpec;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.id.getVersion();
    }

    @JsonProperty
    @JsonSerialize(using=CommaListJoinSerializer.class)
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    @JsonSerialize(using=CommaListJoinSerializer.class)
    public List<String> getMetrics() {
        return this.metrics;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=CommaListJoinSerializer.class)
    public List<String> getProjections() {
        return this.projections;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CompactionState getLastCompactionState() {
        return this.lastCompactionState;
    }

    @JsonProperty
    public Integer getBinaryVersion() {
        return this.binaryVersion;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty(value="identifier", access=JsonProperty.Access.READ_ONLY)
    public SegmentId getId() {
        return this.id;
    }

    public boolean isTombstone() {
        return this.getShardSpec().getType().equals(TOMBSTONE_LOADSPEC_TYPE);
    }

    @Override
    public boolean overshadows(DataSegment other) {
        if (this.id.getDataSource().equals(other.id.getDataSource()) && this.id.getInterval().overlaps((ReadableInterval)other.id.getInterval())) {
            int majorVersionCompare = this.id.getVersion().compareTo(other.id.getVersion());
            if (majorVersionCompare > 0) {
                return true;
            }
            if (majorVersionCompare == 0) {
                return this.includeRootPartitions(other) && this.getMinorVersion() > other.getMinorVersion();
            }
        }
        return false;
    }

    @Override
    public int getStartRootPartitionId() {
        return this.shardSpec.getStartRootPartitionId();
    }

    @Override
    public int getEndRootPartitionId() {
        return this.shardSpec.getEndRootPartitionId();
    }

    @Override
    public short getMinorVersion() {
        return this.shardSpec.getMinorVersion();
    }

    @Override
    public short getAtomicUpdateGroupSize() {
        return this.shardSpec.getAtomicUpdateGroupSize();
    }

    private boolean includeRootPartitions(DataSegment other) {
        return this.shardSpec.getStartRootPartitionId() <= other.shardSpec.getStartRootPartitionId() && this.shardSpec.getEndRootPartitionId() >= other.shardSpec.getEndRootPartitionId();
    }

    public SegmentDescriptor toDescriptor() {
        return this.id.toDescriptor();
    }

    public DataSegment withLoadSpec(Map<String, Object> loadSpec) {
        return DataSegment.builder(this).loadSpec(loadSpec).build();
    }

    public DataSegment withDimensions(List<String> dimensions) {
        return DataSegment.builder(this).dimensions(dimensions).build();
    }

    public DataSegment withMetrics(List<String> metrics) {
        return DataSegment.builder(this).metrics(metrics).build();
    }

    public DataSegment withProjections(List<String> projections) {
        return DataSegment.builder(this).projections(projections).build();
    }

    public DataSegment withShardSpec(ShardSpec newSpec) {
        return DataSegment.builder(this).shardSpec(newSpec).build();
    }

    public DataSegment withSize(long size) {
        return DataSegment.builder(this).size(size).build();
    }

    public DataSegment withVersion(String version) {
        return DataSegment.builder(this).version(version).build();
    }

    public DataSegment withBinaryVersion(int binaryVersion) {
        return DataSegment.builder(this).binaryVersion(binaryVersion).build();
    }

    public DataSegment withLastCompactionState(CompactionState compactionState) {
        return DataSegment.builder(this).lastCompactionState(compactionState).build();
    }

    @Override
    public int compareTo(DataSegment dataSegment) {
        return this.getId().compareTo(dataSegment.getId());
    }

    public boolean equals(Object o) {
        if (o instanceof DataSegment) {
            return this.getId().equals(((DataSegment)o).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "DataSegment{binaryVersion=" + this.binaryVersion + ", id=" + this.id + ", loadSpec=" + this.loadSpec + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", projections=" + this.projections + ", shardSpec=" + this.shardSpec + ", lastCompactionState=" + this.lastCompactionState + ", size=" + this.size + "}";
    }

    @Nullable
    private static Map<String, Object> prepareLoadSpec(@Nullable Map<String, Object> loadSpec) {
        if (loadSpec == null) {
            return null;
        }
        Object2ObjectArrayMap result = new Object2ObjectArrayMap(loadSpec.size());
        for (Map.Entry<String, Object> e : loadSpec.entrySet()) {
            result.put((String)STRING_INTERNER.intern((Object)e.getKey()), e.getValue());
        }
        return result;
    }

    @Nullable
    private static CompactionState prepareCompactionState(@Nullable CompactionState lastCompactionState) {
        if (lastCompactionState == null) {
            return null;
        }
        return (CompactionState)COMPACTION_STATE_INTERNER.intern((Object)lastCompactionState);
    }

    private static List<String> prepareWithInterner(List<String> list, Interner<List<String>> interner) {
        return (List)interner.intern((Object)((List)list.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).map(arg_0 -> STRING_INTERNER.intern(arg_0)).collect(ImmutableList.toImmutableList())));
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SegmentId segmentId) {
        return new Builder(segmentId);
    }

    public static Builder builder(DataSegment segment) {
        return new Builder(segment);
    }

    @Override
    public boolean hasData() {
        return !this.isTombstone();
    }

    @VisibleForTesting
    public static class PruneSpecsHolder {
        @VisibleForTesting
        public static final PruneSpecsHolder DEFAULT = new PruneSpecsHolder();
        @Inject(optional=true)
        @PruneLoadSpec
        boolean pruneLoadSpec = false;
        @Inject(optional=true)
        @PruneLastCompactionState
        boolean pruneLastCompactionState = false;
    }

    public static class Builder {
        private String dataSource;
        private Interval interval;
        private String version;
        private Map<String, Object> loadSpec;
        private List<String> dimensions;
        private List<String> metrics;
        private List<String> projections;
        private ShardSpec shardSpec;
        private CompactionState lastCompactionState;
        private Integer binaryVersion;
        private long size;

        @Deprecated
        private Builder() {
            this.loadSpec = ImmutableMap.of();
            this.dimensions = ImmutableList.of();
            this.metrics = ImmutableList.of();
            this.projections = null;
            this.shardSpec = new NumberedShardSpec(0, 1);
            this.size = -1L;
        }

        private Builder(SegmentId segmentId) {
            this.dataSource = segmentId.getDataSource();
            this.interval = segmentId.getInterval();
            this.version = segmentId.getVersion();
            this.shardSpec = new NumberedShardSpec(0, 1);
            this.binaryVersion = 0;
            this.size = 0L;
            this.lastCompactionState = null;
        }

        private Builder(DataSegment segment) {
            this.dataSource = segment.getDataSource();
            this.interval = segment.getInterval();
            this.version = segment.getVersion();
            this.loadSpec = segment.getLoadSpec();
            this.dimensions = segment.getDimensions();
            this.metrics = segment.getMetrics();
            this.projections = segment.getProjections();
            this.shardSpec = segment.getShardSpec();
            this.lastCompactionState = segment.getLastCompactionState();
            this.binaryVersion = segment.getBinaryVersion();
            this.size = segment.getSize();
        }

        public Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder loadSpec(Map<String, Object> loadSpec) {
            this.loadSpec = loadSpec;
            return this;
        }

        public Builder dimensions(List<String> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder metrics(List<String> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder projections(List<String> projections) {
            this.projections = projections;
            return this;
        }

        public Builder shardSpec(ShardSpec shardSpec) {
            this.shardSpec = shardSpec;
            return this;
        }

        public Builder lastCompactionState(CompactionState compactionState) {
            this.lastCompactionState = compactionState;
            return this;
        }

        public Builder binaryVersion(Integer binaryVersion) {
            this.binaryVersion = binaryVersion;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public DataSegment build() {
            Preconditions.checkNotNull((Object)this.dataSource, (Object)"dataSource");
            Preconditions.checkNotNull((Object)this.interval, (Object)"interval");
            Preconditions.checkNotNull((Object)this.version, (Object)"version");
            Preconditions.checkNotNull((Object)this.shardSpec, (Object)"shardSpec");
            return new DataSegment(this.dataSource, this.interval, this.version, this.loadSpec, this.dimensions, this.metrics, this.projections, this.shardSpec, this.lastCompactionState, this.binaryVersion, this.size, PruneSpecsHolder.DEFAULT);
        }
    }
}

