/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.chatgpt.source.connector;

import io.cloudevents.CloudEvent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.connector.chatgpt.source.config.ChatGPTSourceConfig;
import org.apache.eventmesh.connector.chatgpt.source.dto.ChatGPTRequestDTO;
import org.apache.eventmesh.connector.chatgpt.source.enums.ChatGPTRequestType;
import org.apache.eventmesh.connector.chatgpt.source.handlers.ChatHandler;
import org.apache.eventmesh.connector.chatgpt.source.handlers.ParseHandler;
import org.apache.eventmesh.connector.chatgpt.source.managers.OpenaiManager;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGPTSourceConnector
implements Source {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatGPTSourceConnector.class);
    private ChatGPTSourceConfig sourceConfig;
    private BlockingQueue<CloudEvent> queue;
    private HttpServer server;
    private final ExecutorService chatgptSourceExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"ChatGPTSourceThread");
    private OpenaiManager openaiManager;
    private String parsePromptTemplateStr;
    private ChatHandler chatHandler;
    private ParseHandler parseHandler;
    private static final int DEFAULT_TIMEOUT = 0;
    private static final String APPLICATION_JSON = "application/json";
    private static final String TEXT_PLAIN = "text/plain";
    private int maxBatchSize;
    private long maxPollWaitTime;

    public Class<? extends Config> configClass() {
        return ChatGPTSourceConfig.class;
    }

    public void init(Config config) {
        this.sourceConfig = (ChatGPTSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (ChatGPTSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    public void initParsePrompt() {
        String parsePromptFileName = this.sourceConfig.getConnectorConfig().getParsePromptFileName();
        URL resource = Thread.currentThread().getContextClassLoader().getResource(parsePromptFileName);
        if (resource == null) {
            log.warn("cannot find prompt file {} in resources", (Object)parsePromptFileName);
            return;
        }
        String filePath = resource.getPath();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || !StringUtils.isNotBlank((CharSequence)line)) continue;
                builder.append(line).append("\n");
            }
            this.parsePromptTemplateStr = builder.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file", e);
        }
    }

    private void doInit() {
        this.initParsePrompt();
        this.openaiManager = new OpenaiManager(this.sourceConfig);
        this.chatHandler = new ChatHandler(this.openaiManager);
        if (StringUtils.isNotEmpty((CharSequence)this.parsePromptTemplateStr)) {
            this.parseHandler = new ParseHandler(this.openaiManager, this.parsePromptTemplateStr);
        }
        this.maxBatchSize = this.sourceConfig.getPollConfig().getMaxBatchSize();
        this.maxPollWaitTime = this.sourceConfig.getPollConfig().getMaxWaitTime();
        this.queue = new LinkedBlockingQueue<CloudEvent>(this.sourceConfig.getPollConfig().getCapacity());
        Vertx vertx = Vertx.vertx();
        Router router = Router.router((Vertx)vertx);
        router.route().path(this.sourceConfig.connectorConfig.getPath()).method(HttpMethod.POST).handler((Handler)BodyHandler.create()).handler(ctx -> {
            try {
                RequestBody body = ctx.body();
                ChatGPTRequestDTO bodyObject = (ChatGPTRequestDTO)body.asPojo(ChatGPTRequestDTO.class);
                this.validateRequestDTO(bodyObject);
                this.handleRequest(bodyObject, (RoutingContext)ctx);
            }
            catch (Exception e) {
                this.handleError(e, (RoutingContext)ctx);
            }
        });
        if (this.sourceConfig.connectorConfig.getIdleTimeout() < 0) {
            log.warn("idleTimeout must be >= 0, your config value is {}, idleTimeout will be reset {}", (Object)this.sourceConfig.connectorConfig.getIdleTimeout(), (Object)0);
            this.sourceConfig.connectorConfig.setIdleTimeout(0);
        }
        this.server = vertx.createHttpServer(new HttpServerOptions().setPort(this.sourceConfig.connectorConfig.getPort()).setIdleTimeout(this.sourceConfig.connectorConfig.getIdleTimeout())).requestHandler((Handler)router);
    }

    private void validateRequestDTO(ChatGPTRequestDTO bodyObject) {
        if (StringUtils.isBlank((CharSequence)bodyObject.getText())) {
            throw new IllegalArgumentException("Attributes 'text' cannot be null");
        }
    }

    private void handleRequest(ChatGPTRequestDTO bodyObject, RoutingContext ctx) {
        this.chatgptSourceExecutorService.execute(() -> {
            try {
                ChatGPTRequestType chatgptRequestType = ChatGPTRequestType.valueOf(bodyObject.getRequestType());
                CloudEvent cloudEvent = this.invokeHandler(chatgptRequestType, bodyObject);
                this.queue.add(cloudEvent);
                log.info("[ChatGPTSourceConnector] Succeed to convert payload into CloudEvent.");
                ctx.response().setStatusCode(HttpResponseStatus.OK.code()).end();
            }
            catch (IllegalArgumentException e) {
                log.error("[ChatGPTSourceConnector] the request type is illegal: {}", (Object)e.getMessage(), (Object)e);
                ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).setStatusMessage(String.format("request type '%s' is not supported", bodyObject.getRequestType())).end();
            }
            catch (Exception e) {
                log.error("[ChatGPTSourceConnector] Error processing request: {}", (Object)e.getMessage(), (Object)e);
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
            }
        });
    }

    private CloudEvent invokeHandler(ChatGPTRequestType chatgptRequestType, ChatGPTRequestDTO bodyObject) {
        switch (chatgptRequestType) {
            case CHAT: {
                if (StringUtils.isBlank((CharSequence)bodyObject.getDataContentType())) {
                    bodyObject.setDataContentType(TEXT_PLAIN);
                }
                return this.chatHandler.invoke(bodyObject);
            }
            case PARSE: {
                if (StringUtils.isBlank((CharSequence)this.parsePromptTemplateStr)) {
                    throw new IllegalStateException("the request type of PARSE must be configured with the correct parsePromptFileName in source-config.yml");
                }
                if (StringUtils.isBlank((CharSequence)bodyObject.getFields())) {
                    throw new IllegalStateException("Attributes 'fields' cannot be null in PARSE");
                }
                if (StringUtils.isBlank((CharSequence)bodyObject.getDataContentType())) {
                    bodyObject.setDataContentType(APPLICATION_JSON);
                }
                return this.parseHandler.invoke(bodyObject);
            }
        }
        throw new IllegalStateException("the request type is illegal");
    }

    private void handleError(Exception e, RoutingContext ctx) {
        log.error("[ChatGPTSourceConnector] Malformed request.", (Throwable)e);
        ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end();
    }

    public void start() {
        Throwable t = this.server.listen().cause();
        if (t != null) {
            throw new EventMeshException("failed to start Vertx server", t);
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        Throwable t = this.server.close().cause();
        if (t != null) {
            throw new EventMeshException("failed to stop Vertx server", t);
        }
    }

    public List<ConnectRecord> poll() {
        long startTime = System.currentTimeMillis();
        long remainingTime = this.maxPollWaitTime;
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(this.maxBatchSize);
        for (int i = 0; i < this.maxBatchSize; ++i) {
            try {
                CloudEvent event = this.queue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (event == null) break;
                connectRecords.add(CloudEventUtil.convertEventToRecord((CloudEvent)event));
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = this.maxPollWaitTime > elapsedTime ? this.maxPollWaitTime - elapsedTime : 0L;
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return connectRecords;
    }
}

