/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.remote;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum JobState {
    INIT,
    RUNNING,
    COMPLETE,
    DELETE,
    FAIL,
    PAUSE;

    private static final JobState[] STATES_NUM_INDEX;
    private static final Map<String, JobState> STATES_NAME_INDEX;

    public static JobState fromIndex(Integer index) {
        if (index == null || index < 0 || index >= STATES_NUM_INDEX.length) {
            return null;
        }
        return STATES_NUM_INDEX[index];
    }

    public static JobState fromIndex(String index) {
        if (index == null || index.isEmpty()) {
            return null;
        }
        return STATES_NAME_INDEX.get(index);
    }

    @Generated
    public String toString() {
        return "JobState." + this.name();
    }

    static {
        STATES_NUM_INDEX = JobState.values();
        STATES_NAME_INDEX = new HashMap<String, JobState>();
        for (JobState jobState : STATES_NUM_INDEX) {
            STATES_NAME_INDEX.put(jobState.name(), jobState);
        }
    }
}

