/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.common;

public enum RequestCode {
    UNKNOWN(0, "UNKNOWN"),
    MSG_BATCH_SEND(102, "SEND BATCH MSG"),
    MSG_BATCH_SEND_V2(107, "SEND BATCH MSG V2"),
    MSG_SEND_SYNC(101, "SEND SINGLE MSG SYNC"),
    MSG_SEND_ASYNC(104, "SEND SINGLE MSG ASYNC"),
    HTTP_PUSH_CLIENT_ASYNC(105, "PUSH CLIENT BY HTTP POST"),
    HTTP_PUSH_CLIENT_SYNC(106, "PUSH CLIENT BY HTTP POST"),
    REGISTER(201, "REGISTER"),
    UNREGISTER(202, "UNREGISTER"),
    HEARTBEAT(203, "HEARTBEAT"),
    SUBSCRIBE(206, "SUBSCRIBE"),
    UNSUBSCRIBE(207, "UNSUBSCRIBE"),
    REPLY_MESSAGE(301, "REPLY MESSAGE"),
    ADMIN_METRICS(603, "ADMIN METRICS"),
    ADMIN_SHUTDOWN(601, "ADMIN SHUTDOWN");

    private final Integer requestCode;
    private final String desc;

    private RequestCode(Integer requestCode, String desc) {
        this.requestCode = requestCode;
        this.desc = desc;
    }

    public static boolean contains(Integer requestCode) {
        boolean flag = false;
        for (RequestCode itr : RequestCode.values()) {
            if (itr.requestCode.intValue() != requestCode.intValue()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static RequestCode get(Integer requestCode) {
        RequestCode ret = null;
        for (RequestCode itr : RequestCode.values()) {
            if (itr.requestCode.intValue() != requestCode.intValue()) continue;
            ret = itr;
            break;
        }
        return ret;
    }

    public Integer getRequestCode() {
        return this.requestCode;
    }

    public String getDesc() {
        return this.desc;
    }
}

