/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.AgentIdResolver;
import com.navercorp.pinpoint.bootstrap.AgentIdSourceType;
import com.navercorp.pinpoint.bootstrap.AgentProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class AgentIdResolverBuilder {
    private final List<AgentProperties> agentProperties = new ArrayList<AgentProperties>();

    public void addSystemProperties(Properties system) {
        Objects.requireNonNull(system, "system");
        AgentProperties systemProperties = new AgentProperties(AgentIdSourceType.SYSTEM, system, "pinpoint.agentId", "pinpoint.agentName", "pinpoint.applicationName");
        this.agentProperties.add(systemProperties);
    }

    public void addEnvProperties(Map<String, String> env) {
        Objects.requireNonNull(env, "env");
        AgentProperties envProperties = new AgentProperties(AgentIdSourceType.SYSTEM_ENV, env, "PINPOINT_AGENT_ID", "PINPOINT_AGENT_NAME", "PINPOINT_APPLICATION_NAME");
        this.agentProperties.add(envProperties);
    }

    public void addAgentArgument(Map<String, String> agentArguments) {
        Objects.requireNonNull(agentArguments, "agentArguments");
        AgentProperties agentArgument = new AgentProperties(AgentIdSourceType.AGENT_ARGUMENT, agentArguments, "agentId", "agentName", "applicationName");
        this.agentProperties.add(agentArgument);
    }

    public AgentIdResolver build() {
        ArrayList<AgentProperties> copy = new ArrayList<AgentProperties>(this.agentProperties);
        return new AgentIdResolver(copy);
    }
}

