/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.ProfilePropertyLoader;
import com.navercorp.pinpoint.bootstrap.config.Profiles;
import com.navercorp.pinpoint.bootstrap.config.PropertyLoader;
import com.navercorp.pinpoint.bootstrap.config.SimplePropertyLoader;
import com.navercorp.pinpoint.common.util.SimpleProperty;
import java.nio.file.Path;
import java.util.Objects;

public class PropertyLoaderFactory {
    private final SimpleProperty javaSystemProperty;
    private final SimpleProperty osEnvProperty;
    private final Path agentRootPath;
    private final Path profilesPath;
    private final String[] supportedProfiles;

    public PropertyLoaderFactory(SimpleProperty javaSystemProperty, SimpleProperty osEnvProperty, Path agentRootPath, Path profilesPath, String[] supportedProfiles) {
        this.javaSystemProperty = Objects.requireNonNull(javaSystemProperty, "javaSystemProperty");
        this.osEnvProperty = Objects.requireNonNull(osEnvProperty, "osEnvProperty");
        this.agentRootPath = Objects.requireNonNull(agentRootPath, "agentRootPath");
        this.profilesPath = Objects.requireNonNull(profilesPath, "profilesPath");
        this.supportedProfiles = Objects.requireNonNull(supportedProfiles, "supportedProfiles");
    }

    public PropertyLoader newPropertyLoader() {
        if (this.isSimpleMode()) {
            return new SimplePropertyLoader(this.javaSystemProperty, this.agentRootPath, this.profilesPath);
        }
        return new ProfilePropertyLoader(this.javaSystemProperty, this.osEnvProperty, this.agentRootPath, this.profilesPath, this.supportedProfiles);
    }

    private boolean isSimpleMode() {
        String mode = this.javaSystemProperty.getProperty("pinpoint.config.load.mode", Profiles.CONFIG_LOAD_MODE.PROFILE.toString());
        return Profiles.CONFIG_LOAD_MODE.SIMPLE.toString().equalsIgnoreCase(mode);
    }
}

