/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pulsar.sink.connector;

import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.mq.pulsar.PulsarSinkConfig;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarSinkConnector.class);
    private PulsarSinkConfig sinkConfig;
    private Producer<byte[]> producer;

    public Class<? extends Config> configClass() {
        return PulsarSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (PulsarSinkConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (PulsarSinkConfig)sinkConnectorContext.getSinkConfig();
        this.doInit();
    }

    private void doInit() throws Exception {
        PulsarClient client = PulsarClient.builder().serviceUrl(this.sinkConfig.getConnectorConfig().getServiceUrl()).build();
        this.producer = client.newProducer().topic(this.sinkConfig.getConnectorConfig().getTopic()).create();
    }

    public void start() throws Exception {
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        try {
            this.producer.close();
        }
        catch (PulsarClientException e) {
            log.error("close pulsar producer failed", (Throwable)e);
        }
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            try {
                HashMap<String, String> props = new HashMap<String, String>();
                for (String key : connectRecord.getExtensions().keySet()) {
                    props.put(key, connectRecord.getExtension(key));
                }
                MessageId messageId = this.producer.newMessage().value((Object)((byte[])connectRecord.getData())).properties(props).send();
            }
            catch (Exception e) {
                log.error("put records to pulsar failed", (Throwable)e);
            }
        }
    }
}

