/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.sink.connector;

import io.cloudevents.CloudEvent;
import io.pravega.client.ClientConfig;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.admin.StreamManager;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.ByteArraySerializer;
import io.pravega.shared.security.auth.Credentials;
import io.pravega.shared.security.auth.DefaultCredentials;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.pravega.PravegaSinkConfig;
import org.apache.eventmesh.connector.pravega.client.PravegaCloudEventWriter;
import org.apache.eventmesh.connector.pravega.client.PravegaEvent;
import org.apache.eventmesh.connector.pravega.exception.PravegaConnectorException;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PravegaSinkConnector.class);
    private PravegaSinkConfig sinkConfig;
    private StreamManager streamManager;
    private EventStreamClientFactory clientFactory;
    private final Map<String, EventStreamWriter<byte[]>> writerMap = new ConcurrentHashMap<String, EventStreamWriter<byte[]>>();
    private static final AtomicBoolean started = new AtomicBoolean(false);

    public Class<? extends Config> configClass() {
        return PravegaSinkConfig.class;
    }

    public void init(Config config) throws Exception {
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (PravegaSinkConfig)sinkConnectorContext.getSinkConfig();
        this.streamManager = StreamManager.create((URI)this.sinkConfig.getConnectorConfig().getControllerURI());
        if (!this.streamManager.checkScopeExists(this.sinkConfig.getConnectorConfig().getScope())) {
            this.streamManager.createScope(this.sinkConfig.getConnectorConfig().getScope());
            log.debug("scope[{}] is just created.", (Object)this.sinkConfig.getConnectorConfig().getScope());
        }
        ClientConfig.ClientConfigBuilder clientConfigBuilder = ClientConfig.builder().controllerURI(this.sinkConfig.getConnectorConfig().getControllerURI());
        if (this.sinkConfig.getConnectorConfig().isAuthEnabled()) {
            clientConfigBuilder.credentials((Credentials)new DefaultCredentials(this.sinkConfig.getConnectorConfig().getPassword(), this.sinkConfig.getConnectorConfig().getUsername()));
        }
        if (this.sinkConfig.getConnectorConfig().isTlsEnable()) {
            clientConfigBuilder.trustStore(this.sinkConfig.getConnectorConfig().getTruststore()).validateHostName(false);
        }
        ClientConfig clientConfig = clientConfigBuilder.build();
        this.clientFactory = EventStreamClientFactory.withScope((String)this.sinkConfig.getConnectorConfig().getScope(), (ClientConfig)clientConfig);
    }

    public void start() throws Exception {
        started.compareAndSet(false, true);
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        this.writerMap.forEach((topic, writer) -> writer.close());
        this.writerMap.clear();
        this.clientFactory.close();
        this.streamManager.close();
        started.compareAndSet(true, false);
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            CloudEvent cloudEvent = CloudEventUtil.convertRecordToEvent((ConnectRecord)connectRecord);
            try {
                this.publish(cloudEvent.getSubject(), cloudEvent);
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[PravegaSinkConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
            catch (Exception e) {
                log.error("[PravegaSinkConnector] sendResult has error : ", (Throwable)e);
            }
        }
    }

    private void publish(String topic, CloudEvent cloudEvent) throws Exception {
        if (!this.createStream(topic)) {
            log.debug("stream[{}] has already been created.", (Object)topic);
        }
        try (EventStreamWriter writer = this.writerMap.computeIfAbsent(topic, k -> this.clientFactory.createEventWriter(topic, (Serializer)new ByteArraySerializer(), EventWriterConfig.builder().build()));){
            PravegaCloudEventWriter cloudEventWriter = new PravegaCloudEventWriter(topic);
            PravegaEvent pravegaEvent = (PravegaEvent)cloudEventWriter.writeBinary(cloudEvent);
            writer.writeEvent((Object)PravegaEvent.toByteArray(pravegaEvent)).get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error(String.format("Write topic[%s] fail.", topic), (Throwable)e);
            throw new PravegaConnectorException(String.format("Write topic[%s] fail.", topic));
        }
    }

    private boolean createStream(String topic) {
        StreamConfiguration streamConfiguration = StreamConfiguration.builder().build();
        return this.streamManager.createStream(this.sinkConfig.getConnectorConfig().getScope(), topic, streamConfiguration);
    }
}

