/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.Options;
import org.apache.eventmesh.connector.jdbc.table.catalog.PrimaryKey;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.UniqueKey;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlColumn;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlTableSchema;

public class TableSchema
implements Serializable {
    private TableId tableId = new TableId();
    private Map<String, ? extends Column<?>> columnMap;
    private List<? extends Column<?>> columns;
    private Map<Integer, ? extends Column<?>> orderColumnMap;
    private PrimaryKey primaryKey;
    private List<UniqueKey> uniqueKeys;
    private String comment;

    public TableSchema(TableId tableId, Map<String, ? extends Column<?>> columnMap, List<? extends Column<?>> columns, Map<Integer, ? extends Column<?>> orderColumnMap, PrimaryKey primaryKey, List<UniqueKey> uniqueKeys, String comment) {
        this.tableId = tableId;
        this.columnMap = columnMap;
        this.columns = columns;
        this.orderColumnMap = orderColumnMap;
        this.primaryKey = primaryKey;
        this.uniqueKeys = uniqueKeys;
        this.comment = comment;
    }

    public TableSchema(String name) {
        this.tableId.setTableName(name);
    }

    public TableSchema(TableId tableId) {
        this.tableId = tableId;
    }

    public String getSimpleName() {
        return this.tableId.getTableName();
    }

    public static TableSchemaBuilder newTableSchemaBuilder() {
        return new TableSchemaBuilder();
    }

    public static MysqlTableSchemaBuilder newMysqlTableSchemaBuilder() {
        return new MysqlTableSchemaBuilder();
    }

    @Generated
    public TableId getTableId() {
        return this.tableId;
    }

    @Generated
    public Map<String, ? extends Column<?>> getColumnMap() {
        return this.columnMap;
    }

    @Generated
    public List<? extends Column<?>> getColumns() {
        return this.columns;
    }

    @Generated
    public Map<Integer, ? extends Column<?>> getOrderColumnMap() {
        return this.orderColumnMap;
    }

    @Generated
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Generated
    public List<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public void setTableId(TableId tableId) {
        this.tableId = tableId;
    }

    @Generated
    public void setColumnMap(Map<String, ? extends Column<?>> columnMap) {
        this.columnMap = columnMap;
    }

    @Generated
    public void setColumns(List<? extends Column<?>> columns) {
        this.columns = columns;
    }

    @Generated
    public void setOrderColumnMap(Map<Integer, ? extends Column<?>> orderColumnMap) {
        this.orderColumnMap = orderColumnMap;
    }

    @Generated
    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Generated
    public void setUniqueKeys(List<UniqueKey> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableSchema)) {
            return false;
        }
        TableSchema other = (TableSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableId this$tableId = this.getTableId();
        TableId other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId)) {
            return false;
        }
        Map<String, Column<?>> this$columnMap = this.getColumnMap();
        Map<String, ? extends Column<?>> other$columnMap = other.getColumnMap();
        if (this$columnMap == null ? other$columnMap != null : !((Object)this$columnMap).equals(other$columnMap)) {
            return false;
        }
        List<Column<?>> this$columns = this.getColumns();
        List<? extends Column<?>> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<Integer, Column<?>> this$orderColumnMap = this.getOrderColumnMap();
        Map<Integer, ? extends Column<?>> other$orderColumnMap = other.getOrderColumnMap();
        if (this$orderColumnMap == null ? other$orderColumnMap != null : !((Object)this$orderColumnMap).equals(other$orderColumnMap)) {
            return false;
        }
        PrimaryKey this$primaryKey = this.getPrimaryKey();
        PrimaryKey other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        List<UniqueKey> this$uniqueKeys = this.getUniqueKeys();
        List<UniqueKey> other$uniqueKeys = other.getUniqueKeys();
        if (this$uniqueKeys == null ? other$uniqueKeys != null : !((Object)this$uniqueKeys).equals(other$uniqueKeys)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableSchema;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableId $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        Map<String, Column<?>> $columnMap = this.getColumnMap();
        result = result * 59 + ($columnMap == null ? 43 : ((Object)$columnMap).hashCode());
        List<Column<?>> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<Integer, Column<?>> $orderColumnMap = this.getOrderColumnMap();
        result = result * 59 + ($orderColumnMap == null ? 43 : ((Object)$orderColumnMap).hashCode());
        PrimaryKey $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        List<UniqueKey> $uniqueKeys = this.getUniqueKeys();
        result = result * 59 + ($uniqueKeys == null ? 43 : ((Object)$uniqueKeys).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TableSchema(tableId=" + this.getTableId() + ", columnMap=" + this.getColumnMap() + ", columns=" + this.getColumns() + ", orderColumnMap=" + this.getOrderColumnMap() + ", primaryKey=" + this.getPrimaryKey() + ", uniqueKeys=" + this.getUniqueKeys() + ", comment=" + this.getComment() + ")";
    }

    @Generated
    public TableSchema() {
    }

    public static class MysqlTableSchemaBuilder {
        private TableId tableId = new TableId();
        private Map<String, MysqlColumn> columnMap;
        private Map<Integer, MysqlColumn> orderColumnMap;
        private List<MysqlColumn> columns;
        private PrimaryKey primaryKey;
        private List<UniqueKey> uniqueKeys;
        private String comment;
        private Options tableOptions = new Options();

        public MysqlTableSchemaBuilder withName(String name) {
            this.tableId.setTableName(name);
            return this;
        }

        public MysqlTableSchemaBuilder withTableId(TableId tableId) {
            this.tableId = tableId;
            return this;
        }

        public MysqlTableSchemaBuilder withColumns(List<MysqlColumn> columns) {
            this.columns = columns;
            this.columnMap = ((List)Optional.ofNullable(columns).orElse(new ArrayList(0))).stream().collect(Collectors.toMap(Column::getName, Function.identity()));
            this.orderColumnMap = ((List)Optional.ofNullable(columns).orElse(new ArrayList(0))).stream().collect(Collectors.toMap(Column::getOrder, Function.identity()));
            return this;
        }

        public MysqlTableSchemaBuilder withPrimaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public MysqlTableSchemaBuilder withUniqueKeys(List<UniqueKey> uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            return this;
        }

        public MysqlTableSchemaBuilder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public MysqlTableSchemaBuilder withOption(String key, Object value) {
            this.tableOptions.put(key, value);
            return this;
        }

        public MysqlTableSchemaBuilder withOptions(Options options) {
            this.tableOptions.putAll(options);
            return this;
        }

        public MysqlTableSchema build() {
            return new MysqlTableSchema(this.tableId, this.columnMap, this.columns, this.orderColumnMap, this.primaryKey, this.uniqueKeys, this.comment, this.tableOptions);
        }
    }

    public static class TableSchemaBuilder {
        private TableId tableId;
        private Map<String, Column<?>> columnMap;
        private Map<Integer, Column<?>> orderColumnMap;
        private List<Column<?>> columns;
        private PrimaryKey primaryKey;
        private List<UniqueKey> uniqueKeys;
        private String comment;

        public TableSchemaBuilder withTableId(TableId tableId) {
            this.tableId = tableId;
            return this;
        }

        public TableSchemaBuilder withColumns(Map<String, Column<?>> columnMap) {
            this.columnMap = columnMap;
            return this;
        }

        public TableSchemaBuilder withColumns(List<Column<?>> columns) {
            this.columns = columns;
            return this;
        }

        public TableSchemaBuilder withPrimaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public TableSchemaBuilder withUniqueKeys(List<UniqueKey> uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            return this;
        }

        public TableSchemaBuilder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public TableSchema build() {
            return new TableSchema(this.tableId, this.columnMap, this.columns, this.orderColumnMap, this.primaryKey, this.uniqueKeys, this.comment);
        }
    }
}

