/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.AbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumType
extends AbstractType<byte[]> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnumType.class);
    public static final EnumType INSTANCE = new EnumType();

    private EnumType() {
        super(byte[].class, SQLType.BIT, "ENUM");
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList("enum", "ENUM");
    }

    @Override
    public String getTypeName(Column<?> column) {
        List<String> enumValues = column.getEnumValues();
        if (CollectionUtils.isNotEmpty(enumValues)) {
            return "ENUM(" + enumValues.stream().map(val -> "'" + val + "'").collect(Collectors.joining(", ")) + ")";
        }
        return "ENUM()";
    }

    @Override
    public String getDefaultValue(DatabaseDialect<?> databaseDialect, Column<?> column) {
        if (column.getDefaultValue() == null) {
            return "NULL";
        }
        return "'" + column.getDefaultValue() + "'";
    }
}

