/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.sink.data;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.connector.mcp.sink.data.McpAttemptEvent;

public class MultiMcpRequestContext {
    public static final String NAME = "multi-http-request-context";
    private final AtomicInteger remainingRequests;
    private McpAttemptEvent lastFailedEvent;

    public MultiMcpRequestContext(int remainingEvents) {
        this.remainingRequests = new AtomicInteger(remainingEvents);
    }

    public void decrementRemainingRequests() {
        this.remainingRequests.decrementAndGet();
    }

    public boolean isAllRequestsProcessed() {
        return this.remainingRequests.get() == 0;
    }

    public int getRemainingRequests() {
        return this.remainingRequests.get();
    }

    public McpAttemptEvent getLastFailedEvent() {
        return this.lastFailedEvent;
    }

    public void setLastFailedEvent(McpAttemptEvent lastFailedEvent) {
        this.lastFailedEvent = lastFailedEvent;
    }
}

