/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.sink.handler;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.mcp.SinkConnectorConfig;
import org.apache.eventmesh.connector.mcp.sink.data.McpAttemptEvent;
import org.apache.eventmesh.connector.mcp.sink.data.McpConnectRecord;
import org.apache.eventmesh.connector.mcp.sink.data.MultiMcpRequestContext;
import org.apache.eventmesh.connector.mcp.sink.handler.McpDeliveryStrategy;
import org.apache.eventmesh.connector.mcp.sink.handler.McpSinkHandler;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;

public abstract class AbstractMcpSinkHandler
implements McpSinkHandler {
    private final SinkConnectorConfig sinkConnectorConfig;
    private final List<URI> urls;
    private final McpDeliveryStrategy deliveryStrategy;
    private int roundRobinIndex = 0;

    protected AbstractMcpSinkHandler(SinkConnectorConfig sinkConnectorConfig) {
        this.sinkConnectorConfig = sinkConnectorConfig;
        this.deliveryStrategy = McpDeliveryStrategy.valueOf(sinkConnectorConfig.getDeliveryStrategy());
        String[] urlStrings = sinkConnectorConfig.getUrls();
        this.urls = Arrays.stream(urlStrings).map(URI::create).collect(Collectors.toList());
    }

    @Override
    public void handle(ConnectRecord record) {
        ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        switch (this.deliveryStrategy) {
            case ROUND_ROBIN: {
                attributes.put("multi-http-request-context", new MultiMcpRequestContext(1));
                URI url = this.urls.get(this.roundRobinIndex);
                this.roundRobinIndex = (this.roundRobinIndex + 1) % this.urls.size();
                this.sendRecordToUrl(record, attributes, url);
                break;
            }
            case BROADCAST: {
                attributes.put("multi-http-request-context", new MultiMcpRequestContext(this.urls.size()));
                this.urls.forEach(url0 -> this.sendRecordToUrl(record, (Map<String, Object>)attributes, (URI)url0));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown delivery strategy: " + (Object)((Object)this.deliveryStrategy));
            }
        }
    }

    private void sendRecordToUrl(ConnectRecord record, Map<String, Object> attributes, URI url) {
        String type = String.format("%s.%s.%s", this.sinkConnectorConfig.getConnectorName(), url.getScheme(), "common");
        McpConnectRecord mcpConnectRecord = McpConnectRecord.convertConnectRecord(record, type);
        McpAttemptEvent attemptEvent = new McpAttemptEvent(this.sinkConnectorConfig.getRetryConfig().getMaxRetries() + 1);
        attributes.put("mcp-attempt-event-" + mcpConnectRecord.getMcpRecordId(), attemptEvent);
        this.deliver(url, mcpConnectRecord, attributes, record);
    }

    @Generated
    public SinkConnectorConfig getSinkConnectorConfig() {
        return this.sinkConnectorConfig;
    }

    @Generated
    public List<URI> getUrls() {
        return this.urls;
    }
}

