/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mcp.source;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpToolRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McpToolRegistry.class);
    private final Map<String, McpTool> tools = new ConcurrentHashMap<String, McpTool>();

    public void registerTool(String name, String description, JsonObject inputSchema, ToolExecutor executor) {
        McpTool tool = new McpTool(name, description, inputSchema, executor);
        this.tools.put(name, tool);
        log.info("Registered MCP tool: {}", (Object)name);
    }

    public JsonObject executeTool(String name, JsonObject arguments) {
        McpTool tool = this.tools.get(name);
        if (tool == null) {
            throw new IllegalArgumentException("Unknown tool: " + name);
        }
        try {
            return tool.executor.execute(arguments);
        }
        catch (Exception e) {
            log.error("Tool execution failed: {}", (Object)name, (Object)e);
            throw new RuntimeException("Tool execution failed: " + e.getMessage(), e);
        }
    }

    public JsonArray getToolsArray() {
        JsonArray array = new JsonArray();
        for (McpTool tool : this.tools.values()) {
            JsonObject toolObj = new JsonObject().put("name", (Object)tool.name).put("description", (Object)tool.description).put("inputSchema", (Object)tool.inputSchema);
            array.add((Object)toolObj);
        }
        return array;
    }

    public int getToolCount() {
        return this.tools.size();
    }

    public boolean hasTool(String name) {
        return this.tools.containsKey(name);
    }

    private static class McpTool {
        final String name;
        final String description;
        final JsonObject inputSchema;
        final ToolExecutor executor;

        McpTool(String name, String description, JsonObject inputSchema, ToolExecutor executor) {
            this.name = name;
            this.description = description;
            this.inputSchema = inputSchema;
            this.executor = executor;
        }
    }

    @FunctionalInterface
    public static interface ToolExecutor {
        public JsonObject execute(JsonObject var1) throws Exception;
    }
}

