/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingAsyncState
implements AsyncState {
    private final Logger logger;
    private final AsyncState delegate;

    public LoggingAsyncState(AsyncState delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.logger = LogManager.getLogger(delegate.getClass());
    }

    public void setup() {
        this.logger.debug("setup()");
        this.delegate.setup();
    }

    public boolean await() {
        this.logger.debug("await()");
        return this.delegate.await();
    }

    public void finish() {
        this.logger.debug("finish()");
        this.delegate.finish();
    }

    public String toString() {
        return "LoggingAsyncState{delegate=" + this.delegate + '}';
    }
}

