/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorderFactory;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContextFactory;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapperFactory;
import com.navercorp.pinpoint.profiler.context.exception.sampler.ExceptionChainSampler;
import com.navercorp.pinpoint.profiler.context.exception.storage.ExceptionStorageFactory;
import com.navercorp.pinpoint.profiler.context.monitor.config.ExceptionTraceConfig;
import com.navercorp.pinpoint.profiler.context.provider.exception.ExceptionContextFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.exception.ExceptionRecorderFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.exception.ExceptionStorageFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.exception.ExceptionTraceSamplerProvider;
import com.navercorp.pinpoint.profiler.context.provider.exception.ExceptionWrapperFactoryProvider;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionTraceModule
extends PrivateModule {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ExceptionTraceConfig exceptionTraceConfig;

    public ExceptionTraceModule(ExceptionTraceConfig exceptionTraceConfig) {
        this.exceptionTraceConfig = Objects.requireNonNull(exceptionTraceConfig, "exceptionTraceConfig");
    }

    protected void configure() {
        this.logger.info("configure {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        this.bind(ExceptionTraceConfig.class).toInstance((Object)this.exceptionTraceConfig);
        this.bind(ExceptionChainSampler.class).toProvider(ExceptionTraceSamplerProvider.class).in(Scopes.SINGLETON);
        this.bind(ExceptionWrapperFactory.class).toProvider(ExceptionWrapperFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(ExceptionStorageFactory.class).toProvider(ExceptionStorageFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(ExceptionContextFactory.class).toProvider(ExceptionContextFactoryProvider.class).in(Scopes.SINGLETON);
        this.expose(ExceptionContextFactory.class);
        this.bind(ExceptionRecorderFactory.class).toProvider(ExceptionRecorderFactoryProvider.class).in(Scopes.SINGLETON);
        this.expose(ExceptionRecorderFactory.class);
    }
}

