/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.JvmType;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.ShutdownHookRegister;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownHookRegisterProvider
implements Provider<ShutdownHookRegister> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final String JDK7_SHUTDOWN_HOOK_REGISTER = "com.navercorp.pinpoint.profiler.shutdown.Java7ShutdownHookRegister";
    private static final String JDK9_SHUTDOWN_HOOK_REGISTER = "com.navercorp.pinpoint.profiler.shutdown.Java9ShutdownHookRegister";
    private static final RuntimeShutdownHookRegister RUNTIME_SHUTDOWN_HOOK_REGISTER = new RuntimeShutdownHookRegister();
    private final String vendorName;

    public ShutdownHookRegisterProvider(ContextConfig contextConfig) {
        Objects.requireNonNull(contextConfig, "contextConfig");
        this.vendorName = contextConfig.getProfilerJvmVendorName();
    }

    public ShutdownHookRegister get() {
        JvmType jvmType = JvmType.fromVendor((String)this.vendorName);
        if (jvmType == JvmType.UNKNOWN) {
            jvmType = JvmUtils.getType();
        }
        String classToLoad = this.getShutdownHookRegiterClassName(jvmType);
        return this.createShutdownHookRegister(classToLoad);
    }

    private String getShutdownHookRegiterClassName(JvmType jvmType) {
        JvmVersion jvmVersion = JvmUtils.getVersion();
        if (jvmVersion.onOrAfter(JvmVersion.JAVA_9)) {
            return JDK9_SHUTDOWN_HOOK_REGISTER;
        }
        if (jvmVersion.onOrAfter(JvmVersion.JAVA_7)) {
            return JDK7_SHUTDOWN_HOOK_REGISTER;
        }
        return null;
    }

    private ShutdownHookRegister createShutdownHookRegister(String classToLoad) {
        if (classToLoad == null) {
            return RUNTIME_SHUTDOWN_HOOK_REGISTER;
        }
        try {
            Class<?> shutdownHookRegisterClass = Class.forName(classToLoad);
            try {
                Constructor<?> shutdownHookRegisterConstructorConstructor = shutdownHookRegisterClass.getConstructor(new Class[0]);
                return (ShutdownHookRegister)shutdownHookRegisterConstructorConstructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.logger.warn("Unknown ShutdownHookRegister : {}", (Object)classToLoad);
                return RUNTIME_SHUTDOWN_HOOK_REGISTER;
            }
        }
        catch (ReflectiveOperationException e) {
            this.logger.warn("Error creating ShutdownHookRegister [" + classToLoad + "]", (Throwable)e);
            return RUNTIME_SHUTDOWN_HOOK_REGISTER;
        }
    }

    private static class RuntimeShutdownHookRegister
    implements ShutdownHookRegister {
        private final Logger logger = LogManager.getLogger(this.getClass());

        private RuntimeShutdownHookRegister() {
        }

        @Override
        public void register(Thread thread) {
            Runtime.getRuntime().addShutdownHook(thread);
            this.logger.info("register() completed. (ShutdownHook registered in java.lang.Runtime.)");
        }
    }
}

