/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.sampler;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.util.MapUtils;
import com.navercorp.pinpoint.profiler.context.provider.sampler.UrlSamplerInfo;
import com.navercorp.pinpoint.profiler.sampler.CountingSamplerFactory;
import com.navercorp.pinpoint.profiler.sampler.PercentSamplerFactory;
import com.navercorp.pinpoint.profiler.sampler.SamplerType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UrlSamplerConfig {
    private static final String PREFIX = "profiler.sampling.url.";
    private static final String PATH = ".path";
    private static final String COUNTING_SAMPLING_RATE = ".counting.sampling-rate";
    private static final String PERCENT_SAMPLING_RATE = ".percent.sampling-rate";
    private static final String NEW_THROUGHPUT = ".new.throughput";
    private static final String CONTINUE_THROUGHPUT = ".continue.throughput";
    private static final String PATTERN_REGEX = "profiler.sampling.url.[0-9]+(.path|.counting.sampling-rate|.percent.sampling-rate|.new.throughput|.continue.throughput)";
    private ProfilerConfig config;
    private SamplerType samplerType;

    public UrlSamplerConfig(ProfilerConfig config, SamplerType samplerType) {
        this.config = config;
        this.samplerType = samplerType;
    }

    public List<Map.Entry<Integer, UrlSamplerInfo>> entryList() {
        HashMap<Integer, UrlSamplerInfo> result = new HashMap<Integer, UrlSamplerInfo>();
        Map patterns = this.config.readPattern(PATTERN_REGEX);
        if (MapUtils.isEmpty((Map)patterns)) {
            return Collections.emptyList();
        }
        for (Map.Entry entry : patterns.entrySet()) {
            int number;
            int point;
            String key = (String)entry.getKey();
            if (key == null || !key.startsWith(PREFIX) || (point = key.indexOf(46, PREFIX.length())) < 0 || (number = NumberUtils.parseInteger((String)key.substring(PREFIX.length(), point), (int)-1)) == -1) continue;
            UrlSamplerInfo target = (UrlSamplerInfo)result.get(number);
            if (target == null) {
                target = new UrlSamplerInfo();
                result.put(number, target);
            }
            if (key.endsWith(PATH)) {
                String urlPath = (String)entry.getValue();
                target.setUrlPath(urlPath);
                continue;
            }
            if (key.endsWith(COUNTING_SAMPLING_RATE)) {
                if (this.samplerType != SamplerType.COUNTING) continue;
                int samplingRate = NumberUtils.parseInteger((String)((String)entry.getValue()), (int)-1);
                CountingSamplerFactory factory = new CountingSamplerFactory(samplingRate);
                target.setSampler(factory.createSampler());
                continue;
            }
            if (key.endsWith(PERCENT_SAMPLING_RATE)) {
                if (this.samplerType != SamplerType.PERCENT) continue;
                double samplingRateDouble = NumberUtils.parseDouble((String)((String)entry.getValue()), (double)100.0);
                long samplingRate = (long)(samplingRateDouble * 100.0);
                PercentSamplerFactory factory = new PercentSamplerFactory(samplingRate);
                target.setSampler(factory.createSampler());
                continue;
            }
            if (key.endsWith(NEW_THROUGHPUT)) {
                int samplingNewThroughput = NumberUtils.parseInteger((String)((String)entry.getValue()), (int)0);
                target.setSamplingNewThroughput(samplingNewThroughput);
                continue;
            }
            if (!key.endsWith(CONTINUE_THROUGHPUT)) continue;
            int samplingContinueThroughput = NumberUtils.parseInteger((String)((String)entry.getValue()), (int)0);
            target.setSamplingContinueThroughput(samplingContinueThroughput);
        }
        ArrayList<Map.Entry<Integer, UrlSamplerInfo>> entries = new ArrayList<Map.Entry<Integer, UrlSamplerInfo>>(result.entrySet());
        entries.sort(Comparator.comparingInt(Map.Entry::getKey));
        return entries;
    }
}

