/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import java.lang.reflect.Method;
import java.util.Objects;

public class SetterAnalyzer {
    public SetterDetails analyze(Class<?> setterType) {
        Objects.requireNonNull(setterType, "setterType");
        if (!setterType.isInterface()) {
            throw new IllegalArgumentException("setterType " + setterType + "is not an interface");
        }
        Method[] methods = setterType.getDeclaredMethods();
        if (methods.length != 1) {
            throw new IllegalArgumentException("Setter interface must have only one method: " + setterType.getName());
        }
        Method setter = methods[0];
        if (setter.getParameterCount() != 1) {
            throw new IllegalArgumentException("Setter interface method must have exactly 1 argument: " + setterType.getName());
        }
        Class<?>[] arguments = setter.getParameterTypes();
        Class<?> fieldType = arguments[0];
        Class<?> returnType = setter.getReturnType();
        if (returnType != Void.TYPE) {
            throw new IllegalArgumentException("Setter must have return type void: " + setterType.getName());
        }
        return new SetterDetails(setter, fieldType);
    }

    public static final class SetterDetails {
        private final Method setter;
        private final Class<?> fieldType;

        public SetterDetails(Method setter, Class<?> fieldType) {
            this.setter = setter;
            this.fieldType = fieldType;
        }

        public Method getSetter() {
            return this.setter;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }
    }
}

