/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentCustomMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentCustomMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentCustomMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMetricCollectingJob
implements Runnable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DataSender<MetricType> dataSender;
    private final AgentCustomMetricCollector agentCustomMetricCollector;
    private final int numCollectionsPerBatch;
    private int collectCount = 0;
    private long prevCollectionTimestamp = System.currentTimeMillis();
    private List<AgentCustomMetricSnapshot> agentCustomMetricSnapshotList;

    public CustomMetricCollectingJob(DataSender<MetricType> dataSender, AgentCustomMetricCollector agentCustomMetricCollector, int numCollectionsPerBatch) {
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.agentCustomMetricCollector = Objects.requireNonNull(agentCustomMetricCollector, "agentCustomMetricCollector");
        Assert.isTrue((numCollectionsPerBatch > 0 ? 1 : 0) != 0, (String)"numCollectionsPerBatch must be `numCollectionsPerBatch > 0`");
        this.numCollectionsPerBatch = numCollectionsPerBatch;
        this.agentCustomMetricSnapshotList = new ArrayList<AgentCustomMetricSnapshot>(numCollectionsPerBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long currentCollectionTimestamp = System.currentTimeMillis();
        long collectInterval = currentCollectionTimestamp - this.prevCollectionTimestamp;
        try {
            AgentCustomMetricSnapshot agentCustomMetricSnapshot = this.agentCustomMetricCollector.collect();
            agentCustomMetricSnapshot.setTimestamp(currentCollectionTimestamp);
            agentCustomMetricSnapshot.setCollectInterval(collectInterval);
            this.agentCustomMetricSnapshotList.add(agentCustomMetricSnapshot);
            if (++this.collectCount >= this.numCollectionsPerBatch) {
                this.send();
                this.collectCount = 0;
            }
        }
        catch (Exception ex) {
            this.logger.warn("CustomMetric collect failed. Caused:{}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            this.prevCollectionTimestamp = currentCollectionTimestamp;
        }
    }

    private void send() {
        AgentCustomMetricSnapshotBatch agentCustomMetricSnapshotBatch = new AgentCustomMetricSnapshotBatch(this.agentCustomMetricSnapshotList);
        this.logger.trace("collect agentCustomMetric:{}", (Object)agentCustomMetricSnapshotBatch);
        this.dataSender.send((Object)agentCustomMetricSnapshotBatch);
        this.agentCustomMetricSnapshotList = new ArrayList<AgentCustomMetricSnapshot>(this.numCollectionsPerBatch);
    }
}

