/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginGlobalContext;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.profiler.instrument.GuardInstrumentContext;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.plugin.ClassFileTransformerLoader;
import com.navercorp.pinpoint.profiler.plugin.DefaultProfilerPluginSetupContext;
import com.navercorp.pinpoint.profiler.plugin.GuardProfilerPluginSetupContext;
import com.navercorp.pinpoint.profiler.plugin.PluginInstrumentContext;
import com.navercorp.pinpoint.profiler.plugin.PluginSetup;
import com.navercorp.pinpoint.profiler.plugin.PluginSetupResult;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPluginSetup
implements PluginSetup {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;

    public DefaultPluginSetup(InstrumentEngine instrumentEngine, DynamicTransformTrigger dynamicTransformTrigger) {
        this.instrumentEngine = Objects.requireNonNull(instrumentEngine, "instrumentEngine");
        this.dynamicTransformTrigger = Objects.requireNonNull(dynamicTransformTrigger, "dynamicTransformTrigger");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginSetupResult setupPlugin(ProfilerPluginGlobalContext globalContext, ProfilerPlugin profilerPlugin, ClassInjector classInjector) {
        ProfilerConfig profilerConfig = globalContext.getConfig();
        ClassFileTransformerLoader transformerRegistry = new ClassFileTransformerLoader(profilerConfig, this.dynamicTransformTrigger);
        DefaultProfilerPluginSetupContext setupContext = new DefaultProfilerPluginSetupContext(globalContext);
        GuardProfilerPluginSetupContext guardSetupContext = new GuardProfilerPluginSetupContext(setupContext);
        PluginInstrumentContext instrumentContext = new PluginInstrumentContext(profilerConfig, this.instrumentEngine, this.dynamicTransformTrigger, classInjector, transformerRegistry);
        GuardInstrumentContext guardInstrumentContext = this.preparePlugin(profilerPlugin, instrumentContext);
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("{} Plugin setup", (Object)profilerPlugin.getClass().getName());
            }
            profilerPlugin.setup((ProfilerPluginSetupContext)guardSetupContext);
        }
        finally {
            guardSetupContext.close();
            guardInstrumentContext.close();
        }
        PluginSetupResult setupResult = new PluginSetupResult(setupContext, transformerRegistry);
        return setupResult;
    }

    private GuardInstrumentContext preparePlugin(ProfilerPlugin plugin, InstrumentContext instrumentContext) {
        GuardInstrumentContext guardInstrumentContext = new GuardInstrumentContext(instrumentContext);
        if (plugin instanceof TransformTemplateAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}.setTransformTemplate", (Object)plugin.getClass().getName());
            }
            TransformTemplate transformTemplate = new TransformTemplate((InstrumentContext)guardInstrumentContext);
            ((TransformTemplateAware)plugin).setTransformTemplate(transformTemplate);
        } else if (plugin instanceof MatchableTransformTemplateAware) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}.setTransformTemplate", (Object)plugin.getClass().getName());
            }
            MatchableTransformTemplate transformTemplate = new MatchableTransformTemplate((InstrumentContext)guardInstrumentContext);
            ((MatchableTransformTemplateAware)plugin).setTransformTemplate(transformTemplate);
        }
        return guardInstrumentContext;
    }
}

