/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.grpc;

import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.grpc.trace.PActiveThreadLightDump;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadLightDump;
import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadLightDumpRes;
import com.navercorp.pinpoint.grpc.trace.PCmdRequest;
import com.navercorp.pinpoint.grpc.trace.PCmdResponse;
import com.navercorp.pinpoint.grpc.trace.PThreadLightDump;
import com.navercorp.pinpoint.grpc.trace.ProfilerCommandServiceGrpc;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ThreadDumpMapper;
import com.navercorp.pinpoint.profiler.receiver.grpc.EmptyStreamObserver;
import com.navercorp.pinpoint.profiler.receiver.grpc.ProfilerGrpcCommandService;
import com.navercorp.pinpoint.profiler.receiver.service.ActiveThreadDumpCoreService;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDump;
import com.navercorp.pinpoint.profiler.receiver.service.ThreadDumpRequest;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcActiveThreadLightDumpService
implements ProfilerGrpcCommandService {
    static final String JAVA = "JAVA";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ThreadDumpMapper mapper;
    private final ActiveThreadDumpCoreService activeThreadDump;

    public GrpcActiveThreadLightDumpService(ActiveTraceRepository activeTraceRepository, ThreadDumpMapper threadDumpMapper) {
        Objects.requireNonNull(activeTraceRepository, "activeTraceRepository");
        this.activeThreadDump = new ActiveThreadDumpCoreService(activeTraceRepository);
        this.mapper = Objects.requireNonNull(threadDumpMapper, "threadDumpMapper");
    }

    @Override
    public void handle(PCmdRequest request, ProfilerCommandServiceGrpc.ProfilerCommandServiceStub profilerCommandServiceStub) {
        this.logger.info("simpleCommandService:{}", (Object)request);
        PCmdActiveThreadLightDump commandActiveThreadLightDump = request.getCommandActiveThreadLightDump();
        PCmdActiveThreadLightDumpRes.Builder builder = PCmdActiveThreadLightDumpRes.newBuilder();
        PCmdResponse commonResponse = PCmdResponse.newBuilder().setResponseId(request.getRequestId()).build();
        builder.setCommonResponse(commonResponse);
        builder.setType(JAVA);
        builder.setSubType(JvmUtils.getType().name());
        builder.setVersion(JvmUtils.getVersion().name());
        List<PActiveThreadLightDump> activeThreadDumpList = this.getActiveThreadDumpList(commandActiveThreadLightDump);
        builder.addAllThreadDump(activeThreadDumpList);
        profilerCommandServiceStub.commandActiveThreadLightDump(builder.build(), EmptyStreamObserver.create());
    }

    private List<PActiveThreadLightDump> getActiveThreadDumpList(PCmdActiveThreadLightDump commandActiveThreadLightDump) {
        ThreadDumpRequest request = ThreadDumpRequest.create(commandActiveThreadLightDump);
        Collection<ThreadDump> activeTraceInfoList = this.activeThreadDump.getActiveThreadDumpList(request);
        return this.toPActiveThreadLightDump(activeTraceInfoList);
    }

    private List<PActiveThreadLightDump> toPActiveThreadLightDump(Collection<ThreadDump> activeTraceInfoList) {
        ArrayList<PActiveThreadLightDump> result = new ArrayList<PActiveThreadLightDump>(activeTraceInfoList.size());
        for (ThreadDump threadDump : activeTraceInfoList) {
            PActiveThreadLightDump pActiveThreadLightDump = this.createActiveThreadDump(threadDump);
            result.add(pActiveThreadLightDump);
        }
        return result;
    }

    private PActiveThreadLightDump createActiveThreadDump(ThreadDump threadDump) {
        ActiveTraceSnapshot activeTraceInfo = threadDump.getActiveTraceSnapshot();
        ThreadInfo threadInfo = threadDump.getThreadInfo();
        PThreadLightDump pThreadLightDump = this.createPThreadLightDump(threadInfo);
        PActiveThreadLightDump.Builder builder = PActiveThreadLightDump.newBuilder();
        builder.setStartTime(activeTraceInfo.getStartTime());
        builder.setLocalTraceId(activeTraceInfo.getLocalTransactionId());
        builder.setThreadDump(pThreadLightDump);
        if (activeTraceInfo.isSampled()) {
            builder.setSampled(true);
            builder.setTransactionId(activeTraceInfo.getTransactionId());
            builder.setEntryPoint(activeTraceInfo.getEntryPoint());
        }
        return builder.build();
    }

    private PThreadLightDump createPThreadLightDump(ThreadInfo threadInfo) {
        PThreadLightDump.Builder builder = PThreadLightDump.newBuilder();
        builder.setThreadName(threadInfo.getThreadName());
        builder.setThreadId(threadInfo.getThreadId());
        builder.setThreadState(this.mapper.map(threadInfo.getThreadState()));
        return builder.build();
    }

    @Override
    public short getCommandServiceCode() {
        return 750;
    }
}

