/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc.metric;

import com.google.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzScheduledReporter;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.DefaultChannelzScheduledReporter;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.EmptyChannelzScheduledReporter;
import java.time.Duration;
import java.util.Objects;

public class ChannelzScheduledReporterBuilder {
    private Duration reportPeriod = Duration.ofSeconds(60L);

    public ChannelzScheduledReporterBuilder acceptConfig(ProfilerConfig config) {
        String reportPeriodStr = Objects.requireNonNull(config, "config").getGrpcStatLoggingPeriod();
        this.reportPeriod = Duration.parse(reportPeriodStr);
        return this;
    }

    @VisibleForTesting
    ChannelzScheduledReporterBuilder setReportPeriod(Duration reportPeriod) {
        this.reportPeriod = reportPeriod;
        return this;
    }

    public ChannelzScheduledReporter build() {
        if (this.reportPeriod.toMillis() <= 0L) {
            return new EmptyChannelzScheduledReporter();
        }
        return new DefaultChannelzScheduledReporter(this.reportPeriod);
    }
}

