/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/clientManage/redirectClientBySubSystem")
public class RedirectClientBySubSystemHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedirectClientBySubSystemHandler.class);
    private final transient EventMeshTCPServer eventMeshTCPServer;

    public RedirectClientBySubSystemHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        Map queryStringInfo = NetUtils.formData2Dic((String)URI.create(httpRequest.uri()).getQuery());
        String subSystem = (String)queryStringInfo.get("subsystem");
        String destEventMeshIp = (String)queryStringInfo.get("desteventmeshIp");
        String destEventMeshPort = (String)queryStringInfo.get("desteventmeshport");
        if (!StringUtils.isNumeric((CharSequence)subSystem) || StringUtils.isBlank((CharSequence)destEventMeshIp) || StringUtils.isBlank((CharSequence)destEventMeshPort) || !StringUtils.isNumeric((CharSequence)destEventMeshPort)) {
            this.writeText(ctx, "params illegal!");
            return;
        }
        log.info("redirectClientBySubSystem in admin,subsys:{},destIp:{},destPort:{}====================", new Object[]{subSystem, destEventMeshIp, destEventMeshPort});
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        StringBuilder redirectResult = new StringBuilder();
        try {
            if (!sessionMap.isEmpty()) {
                for (Session session : sessionMap.values()) {
                    if (!session.getClient().getSubsystem().equals(subSystem)) continue;
                    redirectResult.append('|').append(EventMeshTcp2Client.redirectClient2NewEventMesh(this.eventMeshTCPServer.getTcpThreadPoolGroup(), destEventMeshIp, Integer.parseInt(destEventMeshPort), session, clientSessionGroupMapping));
                }
            }
        }
        catch (Exception e) {
            log.error("clientManage|redirectClientBySubSystem|fail|subSystem={}|destEventMeshIp={}|destEventMeshPort={}", new Object[]{subSystem, destEventMeshIp, destEventMeshPort, e});
            this.writeText(ctx, String.format("redirectClientBySubSystem fail! sessionMap size {%d}, {subSystem=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s}, errorMsg : %s", sessionMap.size(), subSystem, destEventMeshIp, destEventMeshPort, redirectResult, e.getMessage()));
            return;
        }
        this.writeText(ctx, String.format("redirectClientBySubSystem success! sessionMap size {%d}, {subSystem=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s} ", sessionMap.size(), subSystem, destEventMeshIp, destEventMeshPort, redirectResult));
    }
}

