/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import lombok.Generated;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.runtime.admin.handler.AdminHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.HttpHandler;
import org.apache.eventmesh.runtime.boot.AbstractHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.boot.SSLContextFactory;
import org.apache.eventmesh.runtime.configuration.EventMeshAdminConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AdminMetricsProcessor;
import org.apache.eventmesh.runtime.util.HttpResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshAdminServer
extends AbstractHTTPServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshAdminServer.class);
    private final EventMeshAdminConfiguration eventMeshAdminConfiguration;
    private AbstractHTTPServer.HttpConnectionHandler httpConnectionHandler = new AbstractHTTPServer.HttpConnectionHandler();
    private AdminHandlerManager adminHandlerManager;
    private ThreadPoolExecutor adminMetricsExecutor;

    public EventMeshAdminServer(EventMeshServer eventMeshServer, EventMeshAdminConfiguration eventMeshAdminConfiguration) {
        super(eventMeshAdminConfiguration.getEventMeshServerAdminPort(), eventMeshAdminConfiguration.isEventMeshServerUseTls(), eventMeshAdminConfiguration);
        this.eventMeshAdminConfiguration = eventMeshAdminConfiguration;
        this.adminHandlerManager = new AdminHandlerManager(eventMeshServer);
    }

    @Override
    public void init() throws Exception {
        super.init("eventMesh-admin");
        this.initThreadPool();
        this.adminHandlerManager.registerHttpHandler();
        this.registerAdminRequestProcessor();
    }

    @Override
    public void start() throws Exception {
        Thread thread = new Thread(() -> {
            ServerBootstrap bootstrap = new ServerBootstrap();
            try {
                ((ServerBootstrap)bootstrap.group(this.getBossGroup(), this.getIoGroup()).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childHandler((ChannelHandler)new AdminServerInitializer(this.isUseTLS() ? SSLContextFactory.getSslContext(this.eventMeshAdminConfiguration) : null, this.isUseTLS())).childOption(ChannelOption.AUTO_CLOSE, (Object)Boolean.TRUE);
                log.info("AdminHttpServer[port={}] started.", (Object)this.getPort());
                bootstrap.bind(this.getPort()).channel().closeFuture().sync();
            }
            catch (Exception e) {
                log.error("AdminHttpServer start error!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception ex) {
                    log.error("AdminHttpServer shutdown error!", (Throwable)ex);
                }
                System.exit(-1);
            }
        }, "EventMesh-admin-server");
        thread.setDaemon(true);
        thread.start();
        this.started.compareAndSet(false, true);
    }

    private void initThreadPool() {
        this.adminMetricsExecutor = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshAdminConfiguration.getEventMeshServerAdminThreadNum(), (int)this.eventMeshAdminConfiguration.getEventMeshServerAdminThreadNum(), new LinkedBlockingQueue(50), (String)"eventMesh-admin-metrics", (boolean)true);
    }

    private void registerAdminRequestProcessor() {
        AdminMetricsProcessor adminMetricsProcessor = new AdminMetricsProcessor(this);
        this.registerProcessor(RequestCode.ADMIN_METRICS.getRequestCode(), adminMetricsProcessor);
    }

    @Generated
    public ThreadPoolExecutor getAdminMetricsExecutor() {
        return this.adminMetricsExecutor;
    }

    private class AdminServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final transient SSLContext sslContext;
        private final transient boolean useTLS;

        public AdminServerInitializer(SSLContext sslContext, boolean useTLS) {
            this.sslContext = sslContext;
            this.useTLS = useTLS;
        }

        protected void initChannel(SocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            if (this.sslContext != null && this.useTLS) {
                SSLEngine sslEngine = this.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(false);
                pipeline.addFirst(EventMeshAdminServer.this.getWorkerGroup(), "ssl", (ChannelHandler)new SslHandler(sslEngine));
            }
            pipeline.addLast(EventMeshAdminServer.this.getWorkerGroup(), new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder(), EventMeshAdminServer.this.httpConnectionHandler, new HttpObjectAggregator(Integer.MAX_VALUE), new SimpleChannelInboundHandler<HttpRequest>(){

                protected void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) {
                    AdminServerInitializer.this.parseHttpRequest(ctx, msg);
                }
            }});
        }

        private void parseHttpRequest(ChannelHandlerContext ctx, HttpRequest httpRequest) {
            String uriStr = httpRequest.uri();
            URI uri = URI.create(uriStr);
            Optional<HttpHandler> httpHandlerOpt = EventMeshAdminServer.this.adminHandlerManager.getHttpHandler(uri.getPath());
            if (httpHandlerOpt.isPresent()) {
                try {
                    httpHandlerOpt.get().handle(httpRequest, ctx);
                }
                catch (Exception e) {
                    log.error("admin server channelRead error", (Throwable)e);
                    ctx.channel().eventLoop().execute(() -> ctx.writeAndFlush((Object)HttpResponseUtils.buildHttpResponse(Objects.requireNonNull(e.getMessage()), ctx, HttpHeaderValues.APPLICATION_JSON, HttpResponseStatus.INTERNAL_SERVER_ERROR)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
                }
            } else {
                ctx.channel().eventLoop().execute(() -> ctx.writeAndFlush((Object)HttpResponseUtils.createNotFound()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
            }
        }
    }
}

