/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshAdminBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshAdminServer;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshHttpBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTcpBootstrap;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.protocol.http.producer.ProducerTopicManager;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.apache.eventmesh.runtime.metrics.EventMeshMetricsManager;
import org.apache.eventmesh.runtime.metrics.MetricsManager;
import org.apache.eventmesh.runtime.storage.StorageResource;
import org.apache.eventmesh.runtime.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshServer.class);
    private final Acl acl;
    private MetaStorage metaStorage;
    private static Trace trace;
    private final StorageResource storageResource;
    private ServiceState serviceState;
    private ProducerTopicManager producerTopicManager;
    private final CommonConfiguration configuration = (CommonConfiguration)configService.buildConfigInstance(CommonConfiguration.class);
    private static final List<EventMeshBootstrap> BOOTSTRAP_LIST;
    private static final String SERVER_STATE_MSG = "server state:{}";
    private static final ConfigService configService;
    private EventMeshTCPServer eventMeshTCPServer = null;
    private EventMeshHTTPServer eventMeshHTTPServer = null;
    private EventMeshGrpcServer eventMeshGrpcServer = null;
    private EventMeshAdminServer eventMeshAdminServer = null;
    private EventMeshMetricsManager eventMeshMetricsManager;

    public EventMeshServer() {
        AssertUtils.notNull((Object)this.configuration, (String)"configuration is null");
        this.acl = Acl.getInstance(this.configuration.getEventMeshSecurityPluginType());
        this.metaStorage = MetaStorage.getInstance(this.configuration.getEventMeshMetaStoragePluginType());
        trace = Trace.getInstance(this.configuration.getEventMeshTracePluginType(), this.configuration.isEventMeshServerTraceEnable());
        this.storageResource = StorageResource.getInstance(this.configuration.getEventMeshStoragePluginType());
        List provideServerProtocols = this.configuration.getEventMeshProvideServerProtocols();
        for (String provideServerProtocol : provideServerProtocols) {
            switch (provideServerProtocol.toUpperCase()) {
                case "HTTP": {
                    BOOTSTRAP_LIST.add(new EventMeshHttpBootstrap(this));
                    break;
                }
                case "TCP": {
                    BOOTSTRAP_LIST.add(new EventMeshTcpBootstrap(this));
                    break;
                }
                case "GRPC": {
                    BOOTSTRAP_LIST.add(new EventMeshGrpcBootstrap(this));
                    break;
                }
            }
        }
        if (BOOTSTRAP_LIST.isEmpty()) {
            BOOTSTRAP_LIST.add(new EventMeshTcpBootstrap(this));
        }
        BOOTSTRAP_LIST.add(new EventMeshAdminBootstrap(this));
        List metricsPluginTypes = this.configuration.getEventMeshMetricsPluginType();
        if (CollectionUtils.isNotEmpty((Collection)metricsPluginTypes)) {
            List<MetricsRegistry> metricsRegistries = metricsPluginTypes.stream().map(metric -> MetricsPluginFactory.getMetricsRegistry((String)metric)).collect(Collectors.toList());
            this.eventMeshMetricsManager = new EventMeshMetricsManager(metricsRegistries);
        }
    }

    public void init() throws Exception {
        MetricsManager metricsManager;
        this.storageResource.init();
        if (this.configuration.isEventMeshServerSecurityEnable()) {
            this.acl.init();
        }
        if (this.configuration.isEventMeshServerMetaStorageEnable()) {
            this.metaStorage.init();
        }
        if (this.configuration.isEventMeshServerTraceEnable()) {
            trace.init();
        }
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.init();
            if (eventMeshBootstrap instanceof EventMeshTcpBootstrap) {
                this.eventMeshTCPServer = ((EventMeshTcpBootstrap)eventMeshBootstrap).getEventMeshTcpServer();
            }
            if (eventMeshBootstrap instanceof EventMeshHttpBootstrap) {
                this.eventMeshHTTPServer = ((EventMeshHttpBootstrap)eventMeshBootstrap).getEventMeshHttpServer();
            }
            if (eventMeshBootstrap instanceof EventMeshGrpcBootstrap) {
                this.eventMeshGrpcServer = ((EventMeshGrpcBootstrap)eventMeshBootstrap).getEventMeshGrpcServer();
            }
            if (!(eventMeshBootstrap instanceof EventMeshAdminBootstrap)) continue;
            this.eventMeshAdminServer = ((EventMeshAdminBootstrap)eventMeshBootstrap).getEventMeshAdminServer();
        }
        if (Objects.nonNull(this.eventMeshTCPServer)) {
            metricsManager = this.eventMeshTCPServer.getEventMeshTcpMetricsManager();
            this.addMetricsManagerAndMetrics(metricsManager);
        }
        if (Objects.nonNull(this.eventMeshGrpcServer)) {
            metricsManager = this.eventMeshGrpcServer.getEventMeshGrpcMetricsManager();
            this.addMetricsManagerAndMetrics(metricsManager);
        }
        if (Objects.nonNull(this.eventMeshHTTPServer)) {
            metricsManager = this.eventMeshHTTPServer.getEventMeshHttpMetricsManager();
            this.addMetricsManagerAndMetrics(metricsManager);
        }
        if (Objects.nonNull(this.eventMeshMetricsManager)) {
            this.eventMeshMetricsManager.init();
        }
        this.producerTopicManager = new ProducerTopicManager(this);
        this.producerTopicManager.init();
        this.serviceState = ServiceState.INITED;
        log.info(SERVER_STATE_MSG, (Object)this.serviceState);
    }

    private void addMetricsManagerAndMetrics(MetricsManager metricsManager) {
        if (Objects.nonNull(metricsManager)) {
            this.eventMeshMetricsManager.addMetricManager(metricsManager);
            this.eventMeshMetricsManager.addMetrics(metricsManager.getMetrics());
        }
    }

    public void start() throws Exception {
        if (Objects.nonNull(this.configuration)) {
            if (this.configuration.isEventMeshServerSecurityEnable()) {
                this.acl.start();
            }
            if (this.configuration.isEventMeshServerMetaStorageEnable()) {
                this.metaStorage.start();
            }
        }
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.start();
        }
        this.producerTopicManager.start();
        this.serviceState = ServiceState.RUNNING;
        log.info(SERVER_STATE_MSG, (Object)this.serviceState);
    }

    public void shutdown() throws Exception {
        this.serviceState = ServiceState.STOPPING;
        log.info(SERVER_STATE_MSG, (Object)this.serviceState);
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.shutdown();
        }
        if (this.configuration != null && this.configuration.isEventMeshServerMetaStorageEnable()) {
            this.metaStorage.shutdown();
        }
        this.storageResource.release();
        if (this.configuration != null && this.configuration.isEventMeshServerSecurityEnable()) {
            this.acl.shutdown();
        }
        if (this.configuration != null && this.configuration.isEventMeshServerTraceEnable()) {
            trace.shutdown();
        }
        this.producerTopicManager.shutdown();
        ConfigurationContextUtil.clear();
        this.serviceState = ServiceState.STOPPED;
        log.info(SERVER_STATE_MSG, (Object)this.serviceState);
    }

    @Generated
    public Acl getAcl() {
        return this.acl;
    }

    @Generated
    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    @Generated
    public void setMetaStorage(MetaStorage metaStorage) {
        this.metaStorage = metaStorage;
    }

    @Generated
    public static Trace getTrace() {
        return trace;
    }

    @Generated
    public ServiceState getServiceState() {
        return this.serviceState;
    }

    @Generated
    public ProducerTopicManager getProducerTopicManager() {
        return this.producerTopicManager;
    }

    @Generated
    public CommonConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    @Generated
    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    @Generated
    public EventMeshGrpcServer getEventMeshGrpcServer() {
        return this.eventMeshGrpcServer;
    }

    @Generated
    public EventMeshAdminServer getEventMeshAdminServer() {
        return this.eventMeshAdminServer;
    }

    static {
        BOOTSTRAP_LIST = new CopyOnWriteArrayList<EventMeshBootstrap>();
        configService = ConfigService.getInstance();
    }
}

