/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.interceptor;

import com.navercorp.pinpoint.grpc.client.interceptor.DiscardEventListener;
import com.navercorp.pinpoint.grpc.client.interceptor.DiscardLimiter;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class DiscardClientCall<ReqT, RespT>
extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
    private static final State OK = new State(false, "OK");
    private static final State NOT_READY = new State(false, "stream not ready");
    private final AtomicBoolean onReadyState = new AtomicBoolean(false);
    private final AtomicLong pendingCounter = new AtomicLong();
    private final long maxPendingThreshold;
    private final DiscardEventListener listener;
    private final DiscardLimiter discardLimiter;

    public DiscardClientCall(ClientCall<ReqT, RespT> delegate, DiscardEventListener listener, long maxPendingThreshold, long discardCountForReconnect, long notReadyTimeoutMillis) {
        super(delegate);
        this.listener = Objects.requireNonNull(listener, "listener");
        this.maxPendingThreshold = maxPendingThreshold;
        this.discardLimiter = new DiscardLimiter(discardCountForReconnect, notReadyTimeoutMillis);
    }

    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
        ForwardingClientCallListener.SimpleForwardingClientCallListener onReadyListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

            public void onReady() {
                DiscardClientCall.this.reset();
                super.onReady();
            }
        };
        super.start((ClientCall.Listener)onReadyListener, headers);
    }

    private void reset() {
        this.onReadyState.compareAndSet(false, true);
        this.pendingCounter.set(0L);
        this.discardLimiter.reset();
    }

    public void sendMessage(ReqT message) {
        State state = this.readyState();
        if (OK == state) {
            super.sendMessage(message);
        } else if (Boolean.FALSE.booleanValue() == state.isCancel()) {
            this.discardMessage(message, state.getMessage());
        } else {
            this.cancel(state.getMessage(), state.getCause());
        }
    }

    private State readyState() {
        if (Boolean.FALSE.booleanValue() == this.onReadyState.get()) {
            long pendingCount = this.pendingCounter.incrementAndGet();
            if (pendingCount > this.maxPendingThreshold) {
                String message = "maximum pending requests " + pendingCount + "/" + this.maxPendingThreshold;
                return new State(false, message);
            }
            return OK;
        }
        boolean ready = this.isReady();
        try {
            this.discardLimiter.discard(ready);
        }
        catch (DiscardLimiter.DiscardLimiterException e) {
            return new State(true, e.getMessage(), e);
        }
        if (Boolean.FALSE == ready) {
            return NOT_READY;
        }
        return OK;
    }

    private void discardMessage(ReqT message, String cause) {
        this.listener.onDiscard(message, cause);
    }

    public void cancel(String message, Throwable cause) {
        this.listener.onCancel(message, cause);
        super.cancel(message, cause);
    }

    public boolean getOnReadyState() {
        return this.onReadyState.get();
    }

    public long getPendingCount() {
        return this.pendingCounter.get();
    }

    private static class State {
        private final boolean cancel;
        private final String message;
        private final Throwable cause;

        public State(boolean cancel, String message) {
            this(cancel, message, null);
        }

        public State(boolean cancel, String message, Throwable cause) {
            this.cancel = cancel;
            this.message = message;
            this.cause = cause;
        }

        public boolean isCancel() {
            return this.cancel;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }
}

