/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.BytesUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;

public class AgentUuidUtils {
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();

    public static String encode(String uuidString) {
        Objects.requireNonNull(uuidString, "uuidString");
        UUID uuid = UUID.fromString(uuidString);
        return AgentUuidUtils.encode(uuid);
    }

    public static String encode(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        byte[] bytes = new byte[16];
        BytesUtils.writeLong(uuid.getMostSignificantBits(), bytes, 0);
        BytesUtils.writeLong(uuid.getLeastSignificantBits(), bytes, 8);
        byte[] encode = ENCODER.encode(bytes);
        return new String(encode, StandardCharsets.US_ASCII);
    }

    public static UUID decode(String src) {
        Objects.requireNonNull(src, "src");
        byte[] bytes = src.getBytes(StandardCharsets.US_ASCII);
        if (bytes.length != 22) {
            throw new IllegalArgumentException("Invalid src byte array: " + src);
        }
        byte[] decoded = Base64.getUrlDecoder().decode(bytes);
        long mostSigBits = BytesUtils.bytesToLong(decoded, 0);
        long leastSigBits = BytesUtils.bytesToLong(decoded, 8);
        return new UUID(mostSigBits, leastSigBits);
    }
}

