/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.sink;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;
import org.apache.eventmesh.connector.canal.sink.GtidBatch;

public class GtidBatchManager {
    private static ConcurrentHashMap<String, GtidBatch> gtidBatchMap = new ConcurrentHashMap();

    public static void addBatch(String gtid, int batchIndex, int totalBatches, List<CanalConnectRecord> batchRecords) {
        gtidBatchMap.computeIfAbsent(gtid, k -> new GtidBatch(totalBatches)).addBatch(batchIndex, batchRecords);
    }

    public static GtidBatch getGtidBatch(String gtid) {
        return gtidBatchMap.get(gtid);
    }

    public static boolean isComplete(String gtid) {
        GtidBatch batch = gtidBatchMap.get(gtid);
        return batch != null && batch.isComplete();
    }

    public static void removeGtidBatch(String gtid) {
        gtidBatchMap.remove(gtid);
    }
}

