/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.HashedWheelTimer;
import io.netty.util.NetUtil;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.redisson.ElementsSubscribeService;
import org.redisson.QueueTransferService;
import org.redisson.RedissonShutdownException;
import org.redisson.Version;
import org.redisson.api.NatMapper;
import org.redisson.api.RFuture;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.RedisNodeNotFoundException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.Protocol;
import org.redisson.config.TransportMode;
import org.redisson.connection.AdderEntry;
import org.redisson.connection.ConnectionEventsHub;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.IdleConnectionWatcher;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.resolver.MapResolver;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.RandomXoshiro256PlusPlus;
import org.redisson.misc.RedisURI;
import org.redisson.remote.ResponseEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Timeout DUMMY_TIMEOUT = new Timeout(){

        public Timer timer() {
            return null;
        }

        public TimerTask task() {
            return null;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean cancel() {
            return true;
        }
    };
    private final ConnectionEventsHub connectionEventsHub = new ConnectionEventsHub();
    private final String id = UUID.randomUUID().toString();
    private final EventLoopGroup group;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final ExecutorService executor;
    private final Config cfg;
    private MasterSlaveServersConfig config;
    private HashedWheelTimer timer;
    private IdleConnectionWatcher connectionWatcher;
    private final AtomicBoolean shutdownLatch = new AtomicBoolean();
    private final ElementsSubscribeService elementsSubscribeService = new ElementsSubscribeService(this);
    private NatMapper natMapper = NatMapper.direct();
    private static final Map<InetSocketAddress, Set<String>> SCRIPT_SHA_CACHE = new ConcurrentHashMap<InetSocketAddress, Set<String>>();
    private static final Map<String, String> SHA_CACHE = new LRUCacheMap<String, String>(500, 0L, 0L);
    private final Map<String, ResponseEntry> responses = new ConcurrentHashMap<String, ResponseEntry>();
    private final QueueTransferService queueTransferService = new QueueTransferService();
    private final AtomicInteger lastFuturesCounter = new AtomicInteger();
    private final Deque<CompletableFuture<?>> lastFutures = new ConcurrentLinkedDeque();
    private final Random random = RandomXoshiro256PlusPlus.create();
    private final AtomicBoolean liveObjectLatch = new AtomicBoolean();
    private static final Map<RedisCommand<?>, RedisCommand<?>> RESP3MAPPING = new HashMap();
    private final Map<String, AdderEntry> addersUsage = new ConcurrentHashMap<String, AdderEntry>();
    private final Map<String, AtomicInteger> addersCounter = new ConcurrentHashMap<String, AtomicInteger>();
    private final MapResolver mapResolver = new MapResolver(this);

    public ServiceManager(MasterSlaveServersConfig config, Config cfg) {
        Version.logVersion();
        if (cfg.getTransportMode() == TransportMode.EPOLL) {
            this.group = cfg.getEventLoopGroup() == null ? (cfg.getNettyExecutor() != null ? new EpollEventLoopGroup(cfg.getNettyThreads(), cfg.getNettyExecutor()) : new EpollEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty"))) : cfg.getEventLoopGroup();
            this.socketChannelClass = EpollSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(EpollDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        } else if (cfg.getTransportMode() == TransportMode.KQUEUE) {
            this.group = cfg.getEventLoopGroup() == null ? (cfg.getNettyExecutor() != null ? new KQueueEventLoopGroup(cfg.getNettyThreads(), cfg.getNettyExecutor()) : new KQueueEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty"))) : cfg.getEventLoopGroup();
            this.socketChannelClass = KQueueSocketChannel.class;
            this.resolverGroup = cfg.getAddressResolverGroupFactory().create(KQueueDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        } else if (cfg.getTransportMode() == TransportMode.IO_URING) {
            this.group = cfg.getEventLoopGroup() == null ? ServiceManager.createIOUringGroup(cfg) : cfg.getEventLoopGroup();
            this.socketChannelClass = IOUringSocketChannel.class;
            this.resolverGroup = cfg.getAddressResolverGroupFactory().create(IOUringDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        } else {
            this.group = cfg.getEventLoopGroup() == null ? (cfg.getNettyExecutor() != null ? new NioEventLoopGroup(cfg.getNettyThreads(), cfg.getNettyExecutor()) : new NioEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty"))) : cfg.getEventLoopGroup();
            this.socketChannelClass = NioSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(NioDatagramChannel.class, this.socketChannelClass, DnsServerAddressStreamProviders.platformDefault());
        }
        if (cfg.getExecutor() == null) {
            int threads = Runtime.getRuntime().availableProcessors() * 2;
            if (cfg.getThreads() != 0) {
                threads = cfg.getThreads();
            }
            this.executor = Executors.newFixedThreadPool(threads, (ThreadFactory)new DefaultThreadFactory("redisson"));
        } else {
            this.executor = cfg.getExecutor();
        }
        this.cfg = cfg;
        this.config = config;
        if (cfg.getConnectionListener() != null) {
            this.connectionEventsHub.addListener(cfg.getConnectionListener());
        }
        this.connectionEventsHub.addListener(new ConnectionListener(){

            @Override
            public void onConnect(InetSocketAddress addr) {
            }

            @Override
            public void onDisconnect(InetSocketAddress addr) {
                SCRIPT_SHA_CACHE.remove(addr);
            }
        });
        this.initTimer();
    }

    private static EventLoopGroup createIOUringGroup(Config cfg) {
        return new IOUringEventLoopGroup(cfg.getNettyThreads(), (ThreadFactory)new DefaultThreadFactory("redisson-netty"));
    }

    private void initTimer() {
        int minTimeout = Math.min(this.config.getRetryInterval(), this.config.getTimeout());
        minTimeout = minTimeout % 100 != 0 ? minTimeout % 100 / 2 : (minTimeout == 100 ? 50 : 100);
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("redisson-timer"), (long)minTimeout, TimeUnit.MILLISECONDS, 1024, false);
        this.connectionWatcher = new IdleConnectionWatcher(this.group, this.config);
    }

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        try {
            return this.timer.newTimeout(task, delay, unit);
        }
        catch (IllegalStateException e) {
            if (this.isShuttingDown()) {
                return DUMMY_TIMEOUT;
            }
            throw e;
        }
    }

    public boolean isShuttingDown() {
        return this.shutdownLatch.get();
    }

    public boolean isShuttingDown(Throwable e) {
        return e instanceof RedissonShutdownException || e.getCause() instanceof RedissonShutdownException;
    }

    public boolean isShutdown() {
        return this.group.isTerminated();
    }

    public ConnectionEventsHub getConnectionEventsHub() {
        return this.connectionEventsHub;
    }

    public String getId() {
        return this.id;
    }

    public EventLoopGroup getGroup() {
        return this.group;
    }

    public CompletableFuture<List<RedisURI>> resolveAll(RedisURI uri) {
        if (uri.isIP()) {
            RedisURI mappedUri = this.toURI(uri.getScheme(), uri.getHost(), "" + uri.getPort());
            return CompletableFuture.completedFuture(Collections.singletonList(mappedUri));
        }
        AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)this.group.next());
        Future future = resolver.resolveAll((SocketAddress)InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort()));
        CompletableFuture<List<RedisURI>> result = new CompletableFuture<List<RedisURI>>();
        future.addListener(f -> {
            if (!f.isSuccess()) {
                this.log.error("Unable to resolve {}", (Object)uri, (Object)f.cause());
                result.completeExceptionally(f.cause());
                return;
            }
            List nodes = ((List)future.getNow()).stream().map(addr -> this.toURI(uri.getScheme(), addr.getAddress().getHostAddress(), "" + addr.getPort())).collect(Collectors.toList());
            result.complete(nodes);
        });
        return result;
    }

    public AddressResolverGroup<InetSocketAddress> getResolverGroup() {
        return this.resolverGroup;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Config getCfg() {
        return this.cfg;
    }

    public HashedWheelTimer getTimer() {
        return this.timer;
    }

    public IdleConnectionWatcher getConnectionWatcher() {
        return this.connectionWatcher;
    }

    public Class<? extends SocketChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public void addFuture(CompletableFuture<?> future) {
        this.lastFutures.addLast(future);
        if (this.lastFuturesCounter.incrementAndGet() > 100) {
            this.lastFutures.pollFirst();
            this.lastFuturesCounter.decrementAndGet();
        }
    }

    public void shutdownFutures(long timeout, TimeUnit unit) {
        CompletableFuture<Void> future = CompletableFuture.allOf(this.lastFutures.toArray(new CompletableFuture[0]));
        try {
            future.get(timeout, unit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastFutures.forEach(f -> f.completeExceptionally(new RedissonShutdownException("Redisson is shutdown")));
        this.lastFutures.clear();
    }

    public void close() {
        this.shutdownLatch.set(true);
    }

    public RedisNodeNotFoundException createNodeNotFoundException(NodeSource source) {
        RedisNodeNotFoundException ex = this.cfg.isClusterConfig() && source.getSlot() != null && source.getAddr() == null && source.getRedisClient() == null ? new RedisNodeNotFoundException("Node for slot: " + source.getSlot() + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.") : new RedisNodeNotFoundException("Node: " + source + " hasn't been discovered yet. Increase value of retryAttempts and/or retryInterval settings.");
        return ex;
    }

    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    public ElementsSubscribeService getElementsSubscribeService() {
        return this.elementsSubscribeService;
    }

    public CompletableFuture<RedisURI> resolveIP(RedisURI address) {
        return this.resolveIP(address.getScheme(), address);
    }

    public CompletableFuture<RedisURI> resolveIP(String scheme, RedisURI address) {
        if (address.isIP()) {
            RedisURI addr = this.toURI(scheme, address.getHost(), "" + address.getPort());
            return CompletableFuture.completedFuture(addr);
        }
        CompletableFuture<RedisURI> result = new CompletableFuture<RedisURI>();
        AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)this.group.next());
        InetSocketAddress addr = InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
        Future future = resolver.resolve((SocketAddress)addr);
        future.addListener((GenericFutureListener)((FutureListener)f -> {
            if (!f.isSuccess()) {
                this.log.error("Unable to resolve {}", (Object)address, (Object)f.cause());
                result.completeExceptionally(f.cause());
                return;
            }
            InetSocketAddress s = (InetSocketAddress)f.getNow();
            RedisURI uri = this.toURI(scheme, s.getAddress().getHostAddress(), "" + address.getPort());
            result.complete(uri);
        }));
        return result;
    }

    public CompletableFuture<InetSocketAddress> resolve(RedisURI address) {
        if (address.isIP()) {
            try {
                InetAddress ip = InetAddress.getByName(address.getHost());
                InetSocketAddress addr = new InetSocketAddress(InetAddress.getByAddress(address.getHost(), ip.getAddress()), address.getPort());
                return CompletableFuture.completedFuture(addr);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        CompletableFuture<InetSocketAddress> result = new CompletableFuture<InetSocketAddress>();
        AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)this.group.next());
        InetSocketAddress addr = InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
        Future future = resolver.resolve((SocketAddress)addr);
        future.addListener((GenericFutureListener)((FutureListener)f -> {
            if (!f.isSuccess()) {
                this.log.error("Unable to resolve {}", (Object)address, (Object)f.cause());
                result.completeExceptionally(f.cause());
                return;
            }
            InetSocketAddress s = (InetSocketAddress)f.getNow();
            RedisURI uri = this.toURI(address.getScheme(), s.getAddress().getHostAddress(), "" + address.getPort());
            if (!uri.getHost().equals(s.getAddress().getHostAddress())) {
                InetAddress ip = InetAddress.getByName(uri.getHost());
                InetSocketAddress mappedAddr = new InetSocketAddress(InetAddress.getByAddress(s.getAddress().getHostAddress(), ip.getAddress()), uri.getPort());
                result.complete(mappedAddr);
                return;
            }
            result.complete(s);
        }));
        return result;
    }

    public RedisURI toURI(String scheme, String host, String port) {
        if (NetUtil.isValidIpV6Address((String)host)) {
            byte[] addr = NetUtil.createByteArrayFromIpAddressString((String)host);
            try {
                InetAddress ia = InetAddress.getByAddress(host, addr);
                host = ia.getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        RedisURI uri = new RedisURI(scheme + "://" + host + ":" + port);
        try {
            return this.natMapper.map(uri);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return uri;
        }
    }

    public void setNatMapper(NatMapper natMapper) {
        this.natMapper = natMapper;
    }

    public NatMapper getNatMapper() {
        return this.natMapper;
    }

    public boolean isCached(InetSocketAddress addr, String script) {
        Set values = SCRIPT_SHA_CACHE.computeIfAbsent(addr, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
        String sha = this.calcSHA(script);
        return values.contains(sha);
    }

    public void cacheScripts(InetSocketAddress addr, Set<String> scripts) {
        Set values = SCRIPT_SHA_CACHE.computeIfAbsent(addr, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
        for (String script : scripts) {
            values.add(this.calcSHA(script));
        }
    }

    public String calcSHA(String script) {
        return SHA_CACHE.computeIfAbsent(script, k -> {
            try {
                MessageDigest mdigest = MessageDigest.getInstance("SHA-1");
                byte[] s = mdigest.digest(script.getBytes(StandardCharsets.UTF_8));
                return ByteBufUtil.hexDump((byte[])s);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public <T> RFuture<T> execute(Supplier<CompletionStage<T>> supplier) {
        CompletableFuture result = new CompletableFuture();
        int retryAttempts = this.config.getRetryAttempts();
        AtomicInteger attempts = new AtomicInteger(retryAttempts);
        this.execute(attempts, result, supplier);
        return new CompletableFutureWrapper(result);
    }

    private <T> void execute(AtomicInteger attempts, CompletableFuture<T> result, Supplier<CompletionStage<T>> supplier) {
        CompletionStage<Object> future = supplier.get();
        future.whenComplete((r, e) -> {
            if (e != null) {
                if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().equals("None of slaves were synced")) {
                    if (attempts.decrementAndGet() < 0) {
                        result.completeExceptionally((Throwable)e);
                        return;
                    }
                    this.newTimeout(arg_0 -> this.lambda$execute$8(attempts, result, (Supplier)supplier, arg_0), this.config.getRetryInterval(), TimeUnit.MILLISECONDS);
                    return;
                }
                result.completeExceptionally((Throwable)e);
                return;
            }
            result.complete(r);
        });
    }

    public <V> void transfer(CompletionStage<V> source, CompletableFuture<V> dest) {
        source.whenComplete((res, e) -> {
            if (e != null) {
                dest.completeExceptionally((Throwable)e);
                return;
            }
            dest.complete(res);
        });
    }

    public Long generateValue() {
        return this.random.nextLong();
    }

    public String generateId() {
        return ByteBufUtil.hexDump((byte[])this.generateIdArray());
    }

    public byte[] generateIdArray() {
        return this.generateIdArray(16);
    }

    public byte[] generateIdArray(int size) {
        byte[] id = new byte[size];
        this.random.nextBytes(id);
        return id;
    }

    public AtomicBoolean getLiveObjectLatch() {
        return this.liveObjectLatch;
    }

    public boolean isResp3() {
        return this.cfg.getProtocol() == Protocol.RESP3;
    }

    public <R> RedisCommand<R> resp3(RedisCommand<R> command) {
        if (this.isResp3()) {
            return RESP3MAPPING.getOrDefault(command, command);
        }
        return command;
    }

    public Map<String, ResponseEntry> getResponses() {
        return this.responses;
    }

    public QueueTransferService getQueueTransferService() {
        return this.queueTransferService;
    }

    public Codec getCodec(Codec codec) {
        if (codec == null) {
            return this.cfg.getCodec();
        }
        return codec;
    }

    public Map<String, AdderEntry> getAddersUsage() {
        return this.addersUsage;
    }

    public Map<String, AtomicInteger> getAddersCounter() {
        return this.addersCounter;
    }

    public MapResolver getLiveObjectMapResolver() {
        return this.mapResolver;
    }

    private /* synthetic */ void lambda$execute$8(AtomicInteger attempts, CompletableFuture result, Supplier supplier, Timeout t) throws Exception {
        this.execute(attempts, result, supplier);
    }

    static {
        RESP3MAPPING.put(RedisCommands.XREADGROUP_BLOCKING, RedisCommands.XREADGROUP_BLOCKING_V2);
        RESP3MAPPING.put(RedisCommands.XREADGROUP, RedisCommands.XREADGROUP_V2);
        RESP3MAPPING.put(RedisCommands.XREADGROUP_BLOCKING_SINGLE, RedisCommands.XREADGROUP_BLOCKING_SINGLE_V2);
        RESP3MAPPING.put(RedisCommands.XREADGROUP_SINGLE, RedisCommands.XREADGROUP_SINGLE_V2);
        RESP3MAPPING.put(RedisCommands.XREAD_BLOCKING_SINGLE, RedisCommands.XREAD_BLOCKING_SINGLE_V2);
        RESP3MAPPING.put(RedisCommands.XREAD_SINGLE, RedisCommands.XREAD_SINGLE_V2);
        RESP3MAPPING.put(RedisCommands.XREAD_BLOCKING, RedisCommands.XREAD_BLOCKING_V2);
        RESP3MAPPING.put(RedisCommands.XREAD, RedisCommands.XREAD_V2);
        RESP3MAPPING.put(RedisCommands.HRANDFIELD, RedisCommands.HRANDFIELD_V2);
    }
}

