/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.sink.entry;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.position.LogIdentity;
import com.alibaba.otter.canal.sink.AbstractCanalEventSink;
import com.alibaba.otter.canal.sink.CanalEventDownStreamHandler;
import com.alibaba.otter.canal.sink.CanalEventSink;
import com.alibaba.otter.canal.sink.entry.HeartBeatEntryEventHandler;
import com.alibaba.otter.canal.sink.exception.CanalSinkException;
import com.alibaba.otter.canal.store.CanalEventStore;
import com.alibaba.otter.canal.store.memory.MemoryEventStoreWithBuffer;
import com.alibaba.otter.canal.store.model.Event;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class EntryEventSink
extends AbstractCanalEventSink<List<CanalEntry.Entry>>
implements CanalEventSink<List<CanalEntry.Entry>> {
    private static final Logger logger = LoggerFactory.getLogger(EntryEventSink.class);
    private static final int maxFullTimes = 10;
    private CanalEventStore<Event> eventStore;
    protected boolean filterTransactionEntry = false;
    protected boolean filterEmtryTransactionEntry = true;
    protected long emptyTransactionInterval = 5000L;
    protected long emptyTransctionThresold = 8192L;
    protected volatile long lastTransactionTimestamp = 0L;
    protected AtomicLong lastTransactionCount = new AtomicLong(0L);
    protected volatile long lastEmptyTransactionTimestamp = 0L;
    protected AtomicLong lastEmptyTransactionCount = new AtomicLong(0L);
    protected AtomicLong eventsSinkBlockingTime = new AtomicLong(0L);
    protected boolean raw;

    public EntryEventSink() {
        this.addHandler(new HeartBeatEntryEventHandler());
    }

    public void start() {
        super.start();
        Assert.notNull(this.eventStore);
        if (this.eventStore instanceof MemoryEventStoreWithBuffer) {
            this.raw = ((MemoryEventStoreWithBuffer)this.eventStore).isRaw();
        }
        for (CanalEventDownStreamHandler handler : this.getHandlers()) {
            if (handler.isStart()) continue;
            handler.start();
        }
    }

    public void stop() {
        super.stop();
        for (CanalEventDownStreamHandler handler : this.getHandlers()) {
            if (!handler.isStart()) continue;
            handler.stop();
        }
    }

    public boolean filter(List<CanalEntry.Entry> event, InetSocketAddress remoteAddress, String destination) {
        return false;
    }

    @Override
    public boolean sink(List<CanalEntry.Entry> entrys, InetSocketAddress remoteAddress, String destination) throws CanalSinkException, InterruptedException {
        return this.sinkData(entrys, remoteAddress);
    }

    private boolean sinkData(List<CanalEntry.Entry> entrys, InetSocketAddress remoteAddress) throws InterruptedException {
        long currentTimestamp;
        boolean hasRowData = false;
        boolean hasHeartBeat = false;
        ArrayList<Event> events = new ArrayList<Event>();
        for (CanalEntry.Entry entry : entrys) {
            if (!this.doFilter(entry)) continue;
            if (this.filterTransactionEntry && (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND)) {
                long currentTimestamp2 = entry.getHeader().getExecuteTime();
                if (this.lastTransactionCount.incrementAndGet() <= this.emptyTransctionThresold && Math.abs(currentTimestamp2 - this.lastTransactionTimestamp) <= this.emptyTransactionInterval) continue;
                if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) {
                    this.lastTransactionCount.set(0L);
                    this.lastTransactionTimestamp = currentTimestamp2;
                }
            }
            hasRowData |= entry.getEntryType() == CanalEntry.EntryType.ROWDATA;
            hasHeartBeat |= entry.getEntryType() == CanalEntry.EntryType.HEARTBEAT;
            Event event = new Event(new LogIdentity(remoteAddress, Long.valueOf(-1L)), entry, this.raw);
            events.add(event);
        }
        if (hasRowData || hasHeartBeat) {
            return this.doSink(events);
        }
        if (this.filterEmtryTransactionEntry && !CollectionUtils.isEmpty(events) && (Math.abs((currentTimestamp = ((Event)events.get(0)).getExecuteTime()) - this.lastEmptyTransactionTimestamp) > this.emptyTransactionInterval || this.lastEmptyTransactionCount.incrementAndGet() > this.emptyTransctionThresold)) {
            this.lastEmptyTransactionCount.set(0L);
            this.lastEmptyTransactionTimestamp = currentTimestamp;
            return this.doSink(events);
        }
        return true;
    }

    protected boolean doFilter(CanalEntry.Entry entry) {
        if (this.filter != null && entry.getEntryType() == CanalEntry.EntryType.ROWDATA) {
            String name = this.getSchemaNameAndTableName(entry);
            boolean need = this.filter.filter((Object)name);
            if (!need) {
                logger.debug("filter name[{}] entry : {}:{}", new Object[]{name, entry.getHeader().getLogfileName(), entry.getHeader().getLogfileOffset()});
            }
            return need;
        }
        return true;
    }

    protected boolean doSink(List<Event> events) {
        for (CanalEventDownStreamHandler handler : this.getHandlers()) {
            events = handler.before(events);
        }
        long blockingStart = 0L;
        int fullTimes = 0;
        do {
            if (this.eventStore.tryPut(events)) {
                if (fullTimes > 0) {
                    this.eventsSinkBlockingTime.addAndGet(System.nanoTime() - blockingStart);
                }
                for (CanalEventDownStreamHandler handler : this.getHandlers()) {
                    events = handler.after(events);
                }
                return true;
            }
            if (fullTimes == 0) {
                blockingStart = System.nanoTime();
            }
            this.applyWait(++fullTimes);
            if (fullTimes % 100 == 0) {
                long nextStart = System.nanoTime();
                this.eventsSinkBlockingTime.addAndGet(nextStart - blockingStart);
                blockingStart = nextStart;
            }
            for (CanalEventDownStreamHandler handler : this.getHandlers()) {
                events = handler.retry(events);
            }
        } while (this.running && !Thread.interrupted());
        return false;
    }

    private void applyWait(int fullTimes) {
        int newFullTimes;
        int n = newFullTimes = fullTimes > 10 ? 10 : fullTimes;
        if (fullTimes <= 3) {
            Thread.yield();
        } else {
            LockSupport.parkNanos(1000000L * (long)newFullTimes);
        }
    }

    private String getSchemaNameAndTableName(CanalEntry.Entry entry) {
        return entry.getHeader().getSchemaName() + "." + entry.getHeader().getTableName();
    }

    public void setEventStore(CanalEventStore<Event> eventStore) {
        this.eventStore = eventStore;
    }

    public void setFilterTransactionEntry(boolean filterTransactionEntry) {
        this.filterTransactionEntry = filterTransactionEntry;
    }

    public void setFilterEmtryTransactionEntry(boolean filterEmtryTransactionEntry) {
        this.filterEmtryTransactionEntry = filterEmtryTransactionEntry;
    }

    public void setEmptyTransactionInterval(long emptyTransactionInterval) {
        this.emptyTransactionInterval = emptyTransactionInterval;
    }

    public void setEmptyTransctionThresold(long emptyTransctionThresold) {
        this.emptyTransctionThresold = emptyTransctionThresold;
    }

    public AtomicLong getEventsSinkBlockingTime() {
        return this.eventsSinkBlockingTime;
    }
}

