/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.producer;

import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.alibaba.otter.canal.common.utils.PropertiesUtils;
import com.alibaba.otter.canal.connector.core.config.MQProperties;
import com.alibaba.otter.canal.connector.core.spi.CanalMQProducer;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractMQProducer
implements CanalMQProducer {
    protected MQProperties mqProperties;
    protected ThreadPoolExecutor sendExecutor;
    protected ThreadPoolExecutor buildExecutor;

    @Override
    public void init(Properties properties) {
        this.loadCanalMqProperties(properties);
        int parallelBuildThreadSize = this.mqProperties.getParallelBuildThreadSize();
        this.buildExecutor = new ThreadPoolExecutor(parallelBuildThreadSize, parallelBuildThreadSize, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(parallelBuildThreadSize * 2), (ThreadFactory)new NamedThreadFactory("MQ-Parallel-Builder"), new ThreadPoolExecutor.CallerRunsPolicy());
        int parallelSendThreadSize = this.mqProperties.getParallelSendThreadSize();
        this.sendExecutor = new ThreadPoolExecutor(parallelSendThreadSize, parallelSendThreadSize, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(parallelSendThreadSize * 2), (ThreadFactory)new NamedThreadFactory("MQ-Parallel-Sender"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public MQProperties getMqProperties() {
        return this.mqProperties;
    }

    @Override
    public void stop() {
        if (this.buildExecutor != null) {
            this.buildExecutor.shutdownNow();
        }
        if (this.sendExecutor != null) {
            this.sendExecutor.shutdownNow();
        }
    }

    private void loadCanalMqProperties(Properties properties) {
        String aliyunUid;
        String aliyunSecretKey;
        String aliyunAccessKey;
        String accessChannel;
        String timeOut;
        String batchSize;
        String parallelSendThreadSize;
        String parallelBuildThreadSize;
        String filterTranEntry;
        String databaseHash;
        String flatMessage = PropertiesUtils.getProperty((Properties)properties, (String)"canal.mq.flatMessage");
        if (!StringUtils.isEmpty((String)flatMessage)) {
            this.mqProperties.setFlatMessage(Boolean.parseBoolean(flatMessage));
        }
        if (!StringUtils.isEmpty((String)(databaseHash = PropertiesUtils.getProperty((Properties)properties, (String)"canal.mq.database.hash")))) {
            this.mqProperties.setDatabaseHash(Boolean.parseBoolean(databaseHash));
        }
        if (!StringUtils.isEmpty((String)(filterTranEntry = PropertiesUtils.getProperty((Properties)properties, (String)"canal.instance.filter.transaction.entry")))) {
            this.mqProperties.setFilterTransactionEntry(Boolean.parseBoolean(filterTranEntry));
        }
        if (!StringUtils.isEmpty((String)(parallelBuildThreadSize = PropertiesUtils.getProperty((Properties)properties, (String)"canal.mq.build.thread.size")))) {
            this.mqProperties.setParallelBuildThreadSize(Integer.parseInt(parallelBuildThreadSize));
        }
        if (!StringUtils.isEmpty((String)(parallelSendThreadSize = PropertiesUtils.getProperty((Properties)properties, (String)"canal.mq.send.thread.size")))) {
            this.mqProperties.setParallelSendThreadSize(Integer.parseInt(parallelSendThreadSize));
        }
        if (!StringUtils.isEmpty((String)(batchSize = PropertiesUtils.getProperty((Properties)properties, (String)"canal.mq.canalBatchSize")))) {
            this.mqProperties.setBatchSize(Integer.parseInt(batchSize));
        }
        if (!StringUtils.isEmpty((String)(timeOut = PropertiesUtils.getProperty((Properties)properties, (String)"canal.mq.canalGetTimeout")))) {
            this.mqProperties.setFetchTimeout(Integer.parseInt(timeOut));
        }
        if (!StringUtils.isEmpty((String)(accessChannel = PropertiesUtils.getProperty((Properties)properties, (String)"canal.mq.accessChannel")))) {
            this.mqProperties.setAccessChannel(accessChannel);
        }
        if (!StringUtils.isEmpty((String)(aliyunAccessKey = PropertiesUtils.getProperty((Properties)properties, (String)"canal.aliyun.accessKey")))) {
            this.mqProperties.setAliyunAccessKey(aliyunAccessKey);
        }
        if (!StringUtils.isEmpty((String)(aliyunSecretKey = PropertiesUtils.getProperty((Properties)properties, (String)"canal.aliyun.secretKey")))) {
            this.mqProperties.setAliyunSecretKey(aliyunSecretKey);
        }
        if (!StringUtils.isEmpty((String)(aliyunUid = PropertiesUtils.getProperty((Properties)properties, (String)"canal.aliyun.uid")))) {
            this.mqProperties.setAliyunUid(Integer.parseInt(aliyunUid));
        }
    }

    protected void doMoreCompatibleConvert(String oldKey, String newKey, Properties properties) {
        String value = PropertiesUtils.getProperty((Properties)properties, (String)oldKey);
        if (StringUtils.isNotEmpty((String)value)) {
            properties.setProperty(newKey, value);
        }
    }
}

