/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.api.AuthenticationDataProvider;

public class AuthenticationDataBasic
implements AuthenticationDataProvider {
    private static final String HTTP_HEADER_NAME = "Authorization";
    private String httpAuthToken;
    private String commandAuthToken;
    private Map<String, String> headers = new HashMap<String, String>();

    public AuthenticationDataBasic(String userId, String password) {
        this.httpAuthToken = "Basic " + Base64.getEncoder().encodeToString((userId + ":" + password).getBytes());
        this.commandAuthToken = userId + ":" + password;
        this.headers.put(HTTP_HEADER_NAME, this.httpAuthToken);
        this.headers.put("X-Pulsar-Auth-Method-Name", "basic");
        this.headers = Collections.unmodifiableMap(this.headers);
    }

    public boolean hasDataForHttp() {
        return true;
    }

    public Set<Map.Entry<String, String>> getHttpHeaders() {
        return this.headers.entrySet();
    }

    public boolean hasDataFromCommand() {
        return true;
    }

    public String getCommandData() {
        return this.commandAuthToken;
    }
}

