/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.ScalingPolicy;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class StreamConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TAG_COUNT = 128;
    private static final int MAX_TAG_LENGTH = 256;
    private final ScalingPolicy scalingPolicy;
    private final RetentionPolicy retentionPolicy;
    private final long timestampAggregationTimeout;
    private final Set<String> tags;
    private final long rolloverSizeBytes;

    public String toString() {
        return String.format("%s = %s", "scalingPolicy", this.scalingPolicy != null ? this.scalingPolicy.toString() : "null") + "\n" + String.format("%s = %s", "retentionPolicy", this.retentionPolicy != null ? this.retentionPolicy.toString() : "null") + "\n" + String.format("%s = %s", "timestampAggregationTimeout", this.timestampAggregationTimeout) + "\n" + String.format("%s = %s", "tags", this.tags) + "\n" + String.format("%s = %s", "rolloverSizeBytes", this.rolloverSizeBytes);
    }

    public static boolean isTagOnlyChange(StreamConfiguration cfg1, StreamConfiguration cfg2) {
        return cfg1.equals(cfg2) && !cfg1.tags.equals(cfg2.tags);
    }

    @ConstructorProperties(value={"scalingPolicy", "retentionPolicy", "timestampAggregationTimeout", "tags", "rolloverSizeBytes"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    StreamConfiguration(ScalingPolicy scalingPolicy, RetentionPolicy retentionPolicy, long timestampAggregationTimeout, Set<String> tags, long rolloverSizeBytes) {
        this.scalingPolicy = scalingPolicy;
        this.retentionPolicy = retentionPolicy;
        this.timestampAggregationTimeout = timestampAggregationTimeout;
        this.tags = tags;
        this.rolloverSizeBytes = rolloverSizeBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static StreamConfigurationBuilder builder() {
        return new StreamConfigurationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public StreamConfigurationBuilder toBuilder() {
        StreamConfigurationBuilder builder = new StreamConfigurationBuilder().scalingPolicy(this.scalingPolicy).retentionPolicy(this.retentionPolicy).timestampAggregationTimeout(this.timestampAggregationTimeout).rolloverSizeBytes(this.rolloverSizeBytes);
        if (this.tags != null) {
            builder.tags(this.tags);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTimestampAggregationTimeout() {
        return this.timestampAggregationTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRolloverSizeBytes() {
        return this.rolloverSizeBytes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamConfiguration)) {
            return false;
        }
        StreamConfiguration other = (StreamConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScalingPolicy this$scalingPolicy = this.getScalingPolicy();
        ScalingPolicy other$scalingPolicy = other.getScalingPolicy();
        if (this$scalingPolicy == null ? other$scalingPolicy != null : !((Object)this$scalingPolicy).equals(other$scalingPolicy)) {
            return false;
        }
        RetentionPolicy this$retentionPolicy = this.getRetentionPolicy();
        RetentionPolicy other$retentionPolicy = other.getRetentionPolicy();
        if (this$retentionPolicy == null ? other$retentionPolicy != null : !((Object)this$retentionPolicy).equals(other$retentionPolicy)) {
            return false;
        }
        if (this.getTimestampAggregationTimeout() != other.getTimestampAggregationTimeout()) {
            return false;
        }
        return this.getRolloverSizeBytes() == other.getRolloverSizeBytes();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScalingPolicy $scalingPolicy = this.getScalingPolicy();
        result = result * 59 + ($scalingPolicy == null ? 43 : ((Object)$scalingPolicy).hashCode());
        RetentionPolicy $retentionPolicy = this.getRetentionPolicy();
        result = result * 59 + ($retentionPolicy == null ? 43 : ((Object)$retentionPolicy).hashCode());
        long $timestampAggregationTimeout = this.getTimestampAggregationTimeout();
        result = result * 59 + (int)($timestampAggregationTimeout >>> 32 ^ $timestampAggregationTimeout);
        long $rolloverSizeBytes = this.getRolloverSizeBytes();
        result = result * 59 + (int)($rolloverSizeBytes >>> 32 ^ $rolloverSizeBytes);
        return result;
    }

    public static final class StreamConfigurationBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private RetentionPolicy retentionPolicy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long timestampAggregationTimeout;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<String> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long rolloverSizeBytes;
        private ScalingPolicy scalingPolicy = ScalingPolicy.fixed(1);

        public StreamConfiguration build() {
            Set<String> tagSet = this.validateTags(this.tags);
            Preconditions.checkArgument((this.rolloverSizeBytes >= 0L ? 1 : 0) != 0, (Object)String.format("Segment rollover size bytes cannot be less than 0, actual is %s", this.rolloverSizeBytes));
            return new StreamConfiguration(this.scalingPolicy, this.retentionPolicy, this.timestampAggregationTimeout, tagSet, this.rolloverSizeBytes);
        }

        private Set<String> validateTags(List<String> tags) {
            Set<String> tagsSet;
            if (tags != null) {
                Preconditions.checkArgument((tags.size() < 128 ? 1 : 0) != 0, (Object)"Maximum number of tags allowed is 128");
                tags.forEach(tag -> Preconditions.checkArgument((tag.length() < 256 ? 1 : 0) != 0, (Object)"Maximum length of a tag allowed is 256"));
            }
            switch (tags == null ? 0 : tags.size()) {
                case 0: {
                    tagsSet = Collections.emptySet();
                    break;
                }
                case 1: {
                    tagsSet = Collections.singleton(this.tags.get(0));
                    break;
                }
                default: {
                    tagsSet = Collections.unmodifiableSet(new HashSet<String>(this.tags));
                }
            }
            return tagsSet;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        StreamConfigurationBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamConfigurationBuilder scalingPolicy(ScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamConfigurationBuilder retentionPolicy(RetentionPolicy retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamConfigurationBuilder timestampAggregationTimeout(long timestampAggregationTimeout) {
            this.timestampAggregationTimeout = timestampAggregationTimeout;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamConfigurationBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamConfigurationBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamConfigurationBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamConfigurationBuilder rolloverSizeBytes(long rolloverSizeBytes) {
            this.rolloverSizeBytes = rolloverSizeBytes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "StreamConfiguration.StreamConfigurationBuilder(scalingPolicy=" + this.scalingPolicy + ", retentionPolicy=" + this.retentionPolicy + ", timestampAggregationTimeout=" + this.timestampAggregationTimeout + ", tags=" + this.tags + ", rolloverSizeBytes=" + this.rolloverSizeBytes + ")";
        }
    }
}

