/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.request.ContinueTraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.DisableTraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.NewTraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.TraceHeader;
import com.navercorp.pinpoint.bootstrap.plugin.request.TraceHeaderReader;
import com.navercorp.pinpoint.bootstrap.sampler.SamplingFlagUtils;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import java.util.Objects;

public class DefaultTraceHeaderReader<T>
implements TraceHeaderReader<T> {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final RequestAdaptor<T> requestAdaptor;

    public DefaultTraceHeaderReader(RequestAdaptor<T> requestAdaptor) {
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
    }

    @Override
    public TraceHeader read(T request) {
        Objects.requireNonNull(request, "request");
        boolean sampling = this.samplingEnable(request);
        if (!sampling) {
            return DisableTraceHeader.INSTANCE;
        }
        String transactionId = this.requestAdaptor.getHeader(request, Header.HTTP_TRACE_ID.toString());
        if (transactionId == null) {
            return NewTraceHeader.INSTANCE;
        }
        String parentSpanIdStr = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_SPAN_ID.toString());
        if (parentSpanIdStr == null) {
            return NewTraceHeader.INSTANCE;
        }
        long parentSpanId = NumberUtils.parseLong(parentSpanIdStr, -1L);
        String spanIdStr = this.requestAdaptor.getHeader(request, Header.HTTP_SPAN_ID.toString());
        if (spanIdStr == null) {
            return NewTraceHeader.INSTANCE;
        }
        long spanId = NumberUtils.parseLong(spanIdStr, -1L);
        short flags = NumberUtils.parseShort(this.requestAdaptor.getHeader(request, Header.HTTP_FLAGS.toString()), (short)0);
        return new ContinueTraceHeader(transactionId, parentSpanId, spanId, flags);
    }

    private boolean samplingEnable(T request) {
        String samplingFlag = this.requestAdaptor.getHeader(request, Header.HTTP_SAMPLED.toString());
        if (this.isDebug) {
            this.logger.debug("SamplingFlag={}", (Object)samplingFlag);
        }
        return SamplingFlagUtils.isSamplingFlag(samplingFlag);
    }
}

