/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.test;

import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedTraceFieldType;
import java.util.Objects;

public class ExpectedTraceField {
    public static final ExpectedTraceField ALWAYS_TRUE = new ExpectedTraceField(ExpectedTraceFieldType.ALWAYS_TRUE);
    public static final ExpectedTraceField EMPTY = new ExpectedTraceField(ExpectedTraceFieldType.EMPTY);
    public static final ExpectedTraceField NOT_EMPTY = new ExpectedTraceField(ExpectedTraceFieldType.NOT_EMPTY);
    private final String expected;
    private final ExpectedTraceFieldType expectedType;

    public ExpectedTraceField(ExpectedTraceFieldType expectedType) {
        this(null, expectedType);
    }

    public ExpectedTraceField(String expected, ExpectedTraceFieldType expectedType) {
        this.expected = expected;
        this.expectedType = Objects.requireNonNull(expectedType, "expectedType");
    }

    public static ExpectedTraceField create(String value) {
        if (value == null) {
            return ExpectedTraceField.createAlwaysTrue();
        }
        return ExpectedTraceField.createEquals(value);
    }

    public static ExpectedTraceField createEquals(String value) {
        return new ExpectedTraceField(value, ExpectedTraceFieldType.EQUALS);
    }

    public static ExpectedTraceField createAlwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static ExpectedTraceField createNotEmpty() {
        return NOT_EMPTY;
    }

    public static ExpectedTraceField createEmpty() {
        return EMPTY;
    }

    public static ExpectedTraceField createStartWith(String value) {
        return new ExpectedTraceField(value, ExpectedTraceFieldType.START_WITH);
    }

    public static ExpectedTraceField createContains(String value) {
        return new ExpectedTraceField(value, ExpectedTraceFieldType.CONTAINS);
    }

    public boolean isEquals(String value) {
        return this.expectedType.isEquals(this.expected, value);
    }

    public String toString() {
        return "ExpectedTraceField{expectedType=" + (Object)((Object)this.expectedType) + ", expected='" + this.expected + '\'' + '}';
    }
}

