/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer.http;

import aQute.bnd.service.Plugin;
import aQute.bnd.service.url.URLConnector;
import aQute.lib.base64.Base64;
import aQute.lib.io.IO;
import aQute.libg.glob.Glob;
import aQute.libg.reporter.Reporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBasicAuthURLConnector
implements URLConnector,
Plugin {
    private static final String PREFIX_PATTERN = "pattern.";
    private static final String PREFIX_USER = "uid.";
    private static final String PREFIX_PASSWORD = "pwd.";
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final List<Mapping> mappings = new LinkedList<Mapping>();
    private Reporter reporter;
    private String configFileList;

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void setProperties(Map<String, String> map) {
        this.configFileList = map.get("configs");
        if (this.configFileList == null) {
            throw new IllegalArgumentException("'configs' must be specified on HttpBasicAuthURLConnector");
        }
    }

    protected void init() {
        if (this.inited.compareAndSet(false, true)) {
            this.mappings.clear();
            StringTokenizer tokenizer = new StringTokenizer(this.configFileList, ",");
            while (tokenizer.hasMoreTokens()) {
                String configFileName = tokenizer.nextToken().trim();
                File file = new File(configFileName);
                if (!file.exists()) continue;
                Properties props = new Properties();
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(file);
                        props.load(stream);
                        for (Object key : props.keySet()) {
                            String name = (String)key;
                            if (!name.startsWith(PREFIX_PATTERN)) continue;
                            String id = name.substring(PREFIX_PATTERN.length());
                            Glob glob = new Glob(props.getProperty(name));
                            String uid = props.getProperty(PREFIX_USER + id);
                            String pwd = props.getProperty(PREFIX_PASSWORD + id);
                            this.mappings.add(new Mapping(glob, uid, pwd));
                        }
                    }
                    catch (IOException e) {
                        this.reporter.error("Failed to load %s", configFileName);
                        if (stream == null) continue;
                        IO.close(stream);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        IO.close(stream);
                    }
                    throw throwable;
                }
                if (stream == null) continue;
                IO.close(stream);
            }
        }
    }

    @Override
    public InputStream connect(URL url) throws IOException {
        this.init();
        for (Mapping mapping : this.mappings) {
            Matcher matcher = mapping.urlPattern.matcher(((Object)url).toString());
            if (!matcher.find()) continue;
            return this.connect(url, mapping.user, mapping.pass);
        }
        return url.openStream();
    }

    private InputStream connect(URL url, String user, String pass) throws IOException {
        String authString = String.valueOf(user) + ":" + pass;
        String encoding = Base64.encodeBase64(authString.getBytes());
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("Authorization", "Basic " + encoding);
        return connection.getInputStream();
    }

    private static class Mapping {
        Glob urlPattern;
        String user;
        String pass;

        Mapping(Glob urlPattern, String user, String pass) {
            this.urlPattern = urlPattern;
            this.user = user;
            this.pass = pass;
        }
    }
}

