/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.api.internal;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

/**
 * An internal class which helps the client to get the execute result from a specific sink.
 *
 * <p>The two iterators are exclusive, that is you can use only one of the two at the same time.
 *
 * <p>This class is generated by specific sink and brings the result info to a {@link TableResult}.
 */
@Internal
public interface ResultProvider {
    /** Set the job client associated with the select job to retrieve the result. */
    ResultProvider setJobClient(JobClient jobClient);

    /**
     * Returns the select result as row iterator using internal data types. You must not invoke this
     * method after invoking {@link #toExternalIterator()}.
     */
    CloseableIterator<RowData> toInternalIterator();

    /**
     * Returns the select result as row iterator using external data types. You must not invoke this
     * method after invoking {@link #toInternalIterator()}.
     */
    CloseableIterator<Row> toExternalIterator();

    RowDataToStringConverter getRowDataStringConverter();

    /**
     * Return true if the first row is ready.
     *
     * <p>The first row is ready when {@link CloseableIterator#hasNext} method returns true or
     * {@link CloseableIterator#next()} method returns a row.
     */
    boolean isFirstRowReady();
}
