/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.util.LambdaUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SavepointOutputFormat
extends RichOutputFormat<CheckpointMetadata> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SavepointOutputFormat.class);
    private final Path savepointPath;
    private transient CheckpointStorageLocation targetLocation;

    public SavepointOutputFormat(Path savepointPath) {
        this.savepointPath = savepointPath;
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        Preconditions.checkState((numTasks == 1 ? 1 : 0) != 0, (Object)"SavepointOutputFormat should only be executed with parallelism 1");
        this.targetLocation = SavepointOutputFormat.createSavepointLocation(this.savepointPath);
    }

    public void writeRecord(CheckpointMetadata metadata) throws IOException {
        String path = (String)LambdaUtil.withContextClassLoader((ClassLoader)this.getRuntimeContext().getUserCodeClassLoader(), () -> {
            try (CheckpointMetadataOutputStream out = this.targetLocation.createMetadataOutputStream();){
                Checkpoints.storeCheckpointMetadata((CheckpointMetadata)metadata, (OutputStream)out);
                CompletedCheckpointStorageLocation finalizedLocation = out.closeAndFinalizeCheckpoint();
                String string = finalizedLocation.getExternalPointer();
                return string;
            }
        });
        LOG.info("Savepoint written to " + path);
    }

    public void close() {
    }

    private static CheckpointStorageLocation createSavepointLocation(Path location) throws IOException {
        CheckpointStorageLocationReference reference = AbstractFsCheckpointStorageAccess.encodePathAsReference((Path)location);
        return new FsCheckpointStorageLocation(location.getFileSystem(), location, location, location, reference, (int)((MemorySize)CheckpointingOptions.FS_SMALL_FILE_THRESHOLD.defaultValue()).getBytes(), ((Integer)CheckpointingOptions.FS_WRITE_BUFFER_SIZE.defaultValue()).intValue());
    }
}

