/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.sql.validate.SqlNameMatcher;

public class FlinkSqlNameMatcher
implements SqlNameMatcher {
    private final SqlNameMatcher baseMatcher;
    private final RelDataTypeFactory typeFactory;

    public FlinkSqlNameMatcher(SqlNameMatcher baseMatcher, RelDataTypeFactory typeFactory) {
        this.baseMatcher = baseMatcher;
        this.typeFactory = typeFactory;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.baseMatcher.isCaseSensitive();
    }

    @Override
    public boolean matches(String string, String name) {
        return this.baseMatcher.matches(string, name);
    }

    @Override
    public <K extends List<String>, V> V get(Map<K, V> map, List<String> prefixNames, List<String> names) {
        return this.baseMatcher.get(map, prefixNames, names);
    }

    @Override
    public String bestString() {
        return this.baseMatcher.bestString();
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String fieldName) {
        RelDataTypeField field = this.baseMatcher.field(rowType, fieldName);
        if (field != null && rowType.isNullable() && !field.getType().isNullable()) {
            RelDataType typeWithNullability = this.typeFactory.createTypeWithNullability(field.getType(), true);
            return new RelDataTypeFieldImpl(field.getName(), field.getIndex(), typeWithNullability);
        }
        return field;
    }

    @Override
    public int frequency(Iterable<String> names, String name) {
        return this.baseMatcher.frequency(names, name);
    }

    @Override
    public Set<String> createSet() {
        return this.baseMatcher.createSet();
    }
}

