/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.SqlToRexConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.typeutils.LogicalRelDataTypeConverter;
import org.apache.flink.table.planner.utils.Expander;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.DataType;

public class SqlNodeConvertContext
implements SqlNodeConverter.ConvertContext {
    private final FlinkPlannerImpl flinkPlanner;
    private final CatalogManager catalogManager;

    public SqlNodeConvertContext(FlinkPlannerImpl flinkPlanner, CatalogManager catalogManager) {
        this.flinkPlanner = flinkPlanner;
        this.catalogManager = catalogManager;
    }

    @Override
    public TableConfig getTableConfig() {
        return ShortcutUtils.unwrapTableConfig(this.flinkPlanner.cluster());
    }

    @Override
    public SqlValidator getSqlValidator() {
        return this.flinkPlanner.getOrCreateSqlValidator();
    }

    @Override
    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    @Override
    public RelRoot toRelRoot(SqlNode sqlNode) {
        return this.flinkPlanner.rel(sqlNode);
    }

    @Override
    public RexNode toRexNode(SqlNode sqlNode, RelDataType inputRowType, @Nullable DataType outputType) {
        RelDataTypeFactory relDataTypeFactory = this.getSqlValidator().getTypeFactory();
        SqlDialect sqlDialect = this.getSqlDialect();
        RelDataType outputRelType = outputType == null ? null : LogicalRelDataTypeConverter.toRelDataType(outputType.getLogicalType(), relDataTypeFactory);
        return new SqlToRexConverter(this.flinkPlanner, sqlDialect, inputRowType, outputRelType).convertToRexNode(sqlNode);
    }

    @Override
    public List<RexNode> reduceRexNodes(List<RexNode> rexNodes) {
        ArrayList<RexNode> reducedNodes = new ArrayList<RexNode>();
        RelOptCluster relOptCluster = this.flinkPlanner.cluster();
        Objects.requireNonNull(relOptCluster.getPlanner().getExecutor()).reduce(relOptCluster.getRexBuilder(), rexNodes, reducedNodes);
        return reducedNodes;
    }

    @Override
    public String toQuotedSqlString(SqlNode sqlNode) {
        return sqlNode.toSqlString(this.getSqlDialect()).getSql();
    }

    private SqlDialect getSqlDialect() {
        SqlParser.Config parserConfig = this.flinkPlanner.config().getParserConfig();
        return new AnsiSqlDialect(SqlDialect.EMPTY_CONTEXT.withQuotedCasing(parserConfig.unquotedCasing()).withConformance(parserConfig.conformance()).withUnquotedCasing(parserConfig.unquotedCasing()).withIdentifierQuoteString(parserConfig.quoting().string));
    }

    @Override
    public String expandSqlIdentifiers(String originalSql) {
        return Expander.create(this.flinkPlanner).expanded(originalSql).substitute(this::toQuotedSqlString);
    }
}

