/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.lang.reflect.Constructor;
import java.util.Collections;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecLimit;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.runtime.script.ScriptTransformIOInfo;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;

public class BatchExecScriptTransform
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private static final String HIVE_SCRIPT_TRANSFORM_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.hive.script.HiveScriptTransformOperator";
    private final int[] inputIndexes;
    private final String script;
    private final ScriptTransformIOInfo scriptTransformIOInfo;
    private final LogicalType inputType;

    public BatchExecScriptTransform(ReadableConfig tableConfig, InputProperty inputProperty, LogicalType inputType, LogicalType outputType, String description, int[] inputIndexes, String script, ScriptTransformIOInfo scriptTransformIOInfo) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecLimit.class), ExecNodeContext.newPersistedConfig(BatchExecLimit.class, tableConfig), Collections.singletonList(inputProperty), outputType, description);
        this.inputIndexes = inputIndexes;
        this.script = script;
        this.inputType = inputType;
        this.scriptTransformIOInfo = scriptTransformIOInfo;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<?> inputTransform = this.getInputEdges().get(0).translateToPlan(planner);
        OneInputStreamOperator<RowData, RowData> scriptOperator = this.getScriptTransformOperator();
        return new OneInputTransformation(inputTransform, this.getDescription(), (StreamOperatorFactory)SimpleOperatorFactory.of(scriptOperator), (TypeInformation)InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), false);
    }

    private OneInputStreamOperator<RowData, RowData> getScriptTransformOperator() {
        try {
            Class<?> cls = Class.forName(HIVE_SCRIPT_TRANSFORM_OPERATOR_NAME, false, Thread.currentThread().getContextClassLoader());
            Constructor<?> ctor = cls.getConstructor(int[].class, String.class, ScriptTransformIOInfo.class, LogicalType.class, LogicalType.class);
            return (OneInputStreamOperator)ctor.newInstance(this.inputIndexes, this.script, this.scriptTransformIOInfo, this.inputType, this.getOutputType());
        }
        catch (Exception e) {
            throw new TableException("HiveScriptTransformOperator constructed failed.", (Throwable)e);
        }
    }
}

