/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNestedLoopJoin;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalJoinBase;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001U\u00111DQ1uG\"\u0004\u0006._:jG\u0006dg*Z:uK\u0012dun\u001c9K_&t'BA\u0002\u0005\u0003\u0015\u0011\u0017\r^2i\u0015\t)a!\u0001\u0005qQf\u001c\u0018nY1m\u0015\t9\u0001\"A\u0003o_\u0012,7O\u0003\u0002\n\u0015\u0005!\u0001\u000f\\1o\u0015\tYA\"A\u0004qY\u0006tg.\u001a:\u000b\u00055q\u0011!\u0002;bE2,'BA\b\u0011\u0003\u00151G.\u001b8l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011AA\u0005\u00033\t\u0011QCQ1uG\"\u0004\u0006._:jG\u0006d'j\\5o\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u001d\u0019G.^:uKJ\u0004\"!H\u0011\u000e\u0003yQ!!C\u0010\u000b\u0005\u0001\u0002\u0012aB2bY\u000eLG/Z\u0005\u0003Ey\u0011QBU3m\u001fB$8\t\\;ti\u0016\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0011Q\u0014\u0018-\u001b;TKR\u0004\"!\b\u0014\n\u0005\u001dr\"a\u0003*fYR\u0013\u0018-\u001b;TKRD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\bY\u00164GOU3m!\tYc&D\u0001-\u0015\tis$A\u0002sK2L!a\f\u0017\u0003\u000fI+GNT8eK\"A\u0011\u0007\u0001B\u0001B\u0003%!&\u0001\u0005sS\u001eDGOU3m\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014!C2p]\u0012LG/[8o!\t)\u0004(D\u00017\u0015\t9t$A\u0002sKbL!!\u000f\u001c\u0003\u000fI+\u0007PT8eK\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0005k_&tG+\u001f9f!\ti\u0004)D\u0001?\u0015\tyD&\u0001\u0003d_J,\u0017BA!?\u0005-Qu.\u001b8SK2$\u0016\u0010]3\t\u0011\r\u0003!Q1A\u0005\u0002\u0011\u000b1\u0002\\3gi&\u001b()^5mIV\tQ\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuIA\u0004C_>dW-\u00198\t\u00111\u0003!\u0011!Q\u0001\n\u0015\u000bA\u0002\\3gi&\u001b()^5mI\u0002B\u0001B\u0014\u0001\u0003\u0006\u0004%\t\u0001R\u0001\u000eg&tw\r\\3S_^Tu.\u001b8\t\u0011A\u0003!\u0011!Q\u0001\n\u0015\u000bab]5oO2,'k\\<K_&t\u0007\u0005C\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\n)V3v\u000bW-[7r\u0003\"a\u0006\u0001\t\u000bm\t\u0006\u0019\u0001\u000f\t\u000b\u0011\n\u0006\u0019A\u0013\t\u000b%\n\u0006\u0019\u0001\u0016\t\u000bE\n\u0006\u0019\u0001\u0016\t\u000bM\n\u0006\u0019\u0001\u001b\t\u000bm\n\u0006\u0019\u0001\u001f\t\u000b\r\u000b\u0006\u0019A#\t\u000b9\u000b\u0006\u0019A#\t\u000by\u0003A\u0011I0\u0002\t\r|\u0007/\u001f\u000b\bA\u000e$g\r\u001b6l!\ti\u0014-\u0003\u0002c}\t!!j\\5o\u0011\u0015!S\f1\u0001&\u0011\u0015)W\f1\u00015\u00035\u0019wN\u001c3ji&|g.\u0012=qe\")q-\u0018a\u0001U\u0005!A.\u001a4u\u0011\u0015IW\f1\u0001+\u0003\u0015\u0011\u0018n\u001a5u\u0011\u0015YT\f1\u0001=\u0011\u0015aW\f1\u0001F\u00031\u0019X-\\5K_&tGi\u001c8f\u0011\u0015q\u0007\u0001\"\u0011p\u00031)\u0007\u0010\u001d7bS:$VM]7t)\t\u00018\u000f\u0005\u0002,c&\u0011!\u000f\f\u0002\n%\u0016dwK]5uKJDQ\u0001^7A\u0002A\f!\u0001]<\t\u000bY\u0004A\u0011I<\u0002\u001f\r|W\u000e];uKN+GNZ\"pgR$2\u0001_>\u0000!\ti\u00120\u0003\u0002{=\tQ!+\u001a7PaR\u001cun\u001d;\t\u000b-)\b\u0019\u0001?\u0011\u0005ui\u0018B\u0001@\u001f\u00055\u0011V\r\\(qiBc\u0017M\u001c8fe\"9\u0011\u0011A;A\u0002\u0005\r\u0011AA7r!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005Y\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002\u000e\u0005\u001d!\u0001\u0005*fY6+G/\u00193bi\u0006\fV/\u001a:z\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\t\u0011c\u001d5vM\u001adWMQ;jY\u0012\u001cu.\u001e8u)\u0011\t)\"a\u0007\u0011\u0007\u0019\u000b9\"C\u0002\u0002\u001a\u001d\u00131!\u00138u\u0011!\t\t!a\u0004A\u0002\u0005\r\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0001\u000eg\u0006$\u0018n\u001d4z)J\f\u0017\u000e^:\u0015\t\u0005\r\u0012\u0011\u0006\t\u0005\r\u0006\u0015\"&C\u0002\u0002(\u001d\u0013aa\u00149uS>t\u0007bBA\u0016\u0003;\u0001\r!J\u0001\u0011e\u0016\fX/\u001b:fIR\u0013\u0018-\u001b;TKRDq!a\f\u0001\t\u0003\n\t$A\nue\u0006t7\u000f\\1uKR{W\t_3d\u001d>$W\r\u0006\u0002\u00024A\"\u0011QGA#!\u0019\t9$!\u0010\u0002B5\u0011\u0011\u0011\b\u0006\u0004\u0003w1\u0011\u0001B3yK\u000eLA!a\u0010\u0002:\tAQ\t_3d\u001d>$W\r\u0005\u0003\u0002D\u0005\u0015C\u0002\u0001\u0003\r\u0003\u000f\ni#!A\u0001\u0002\u000b\u0005\u0011\u0011\n\u0002\u0004?\u0012\n\u0014\u0003BA&\u0003#\u00022ARA'\u0013\r\tye\u0012\u0002\b\u001d>$\b.\u001b8h!\r1\u00151K\u0005\u0004\u0003+:%aA!os\"9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013AE4fi&s\u0007/\u001e;Qe>\u0004XM\u001d;jKN,\"!!\u0018\u0011\u000f\u0019\u000by&a\u0019\u0002d%\u0019\u0011\u0011M$\u0003\rQ+\b\u000f\\33!\u0011\t9$!\u001a\n\t\u0005\u001d\u0014\u0011\b\u0002\u000e\u0013:\u0004X\u000f\u001e)s_B,'\u000f^=")
public class BatchPhysicalNestedLoopJoin
extends BatchPhysicalJoinBase {
    private final RelOptCluster cluster;
    private final RexNode condition;
    private final JoinRelType joinType;
    private final boolean leftIsBuild;
    private final boolean singleRowJoin;

    public boolean leftIsBuild() {
        return this.leftIsBuild;
    }

    public boolean singleRowJoin() {
        return this.singleRowJoin;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchPhysicalNestedLoopJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftIsBuild(), this.singleRowJoin());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("build", this.leftIsBuild() ? "left" : "right").itemIf("singleRowJoin", BoxesRunTime.boxToBoolean((boolean)this.singleRowJoin()), this.singleRowJoin());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        RelNode buildRel = this.leftIsBuild() ? this.getLeft() : this.getRight();
        Double buildRows = mq.getRowCount(buildRel);
        Double buildRowSize = mq.getAverageRowSize(buildRel);
        double memoryCost = Predef$.MODULE$.Double2double(buildRows) * (Predef$.MODULE$.Double2double(buildRowSize) + (double)4) * (double)this.shuffleBuildCount(mq);
        double cpuCost = Predef$.MODULE$.Double2double(leftRowCnt) * Predef$.MODULE$.Double2double(rightRowCnt);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        RelOptCost cost = costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount(this)), cpuCost, 0.0, 0.0, memoryCost);
        return this.singleRowJoin() ? cost.multiplyBy(0.99) : cost;
    }

    private int shuffleBuildCount(RelMetadataQuery mq) {
        int n;
        RelNode probeRel = this.leftIsBuild() ? this.getRight() : this.getLeft();
        Double rowCount = mq.getRowCount(probeRel);
        if (rowCount == null) {
            n = 1;
        } else {
            Double probeRowSize = mq.getAverageRowSize(probeRel);
            n = Math.max(1, (int)(Predef$.MODULE$.Double2double(rowCount) * Predef$.MODULE$.Double2double(probeRowSize) / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
        }
        return n;
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return this.satisfyTraitsOnBroadcastJoin(requiredTraitSet, this.leftIsBuild());
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        Tuple2<InputProperty, InputProperty> tuple2 = this.getInputProperties();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputProperty leftInputProperty = (InputProperty)tuple2._1();
        InputProperty rightInputProperty = (InputProperty)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftInputProperty, (Object)rightInputProperty);
        Tuple2 tuple23 = tuple22;
        InputProperty leftInputProperty2 = (InputProperty)tuple23._1();
        InputProperty rightInputProperty2 = (InputProperty)tuple23._2();
        return new BatchExecNestedLoopJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), JoinTypeUtil.getFlinkJoinType(this.joinType), this.condition, this.leftIsBuild(), this.singleRowJoin(), leftInputProperty2, rightInputProperty2, FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    public Tuple2<InputProperty, InputProperty> getInputProperties() {
        Tuple2 tuple2;
        JoinRelType joinRelType = this.joinType;
        JoinRelType joinRelType2 = JoinRelType.FULL;
        Tuple2 tuple22 = !(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType2) : joinRelType2 != null) ? new Tuple2((Object)InputProperty.SINGLETON_DISTRIBUTION, (Object)InputProperty.SINGLETON_DISTRIBUTION) : (tuple2 = new Tuple2((Object)InputProperty.BROADCAST_DISTRIBUTION, (Object)InputProperty.ANY_DISTRIBUTION));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputProperty.RequiredDistribution buildRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._1();
        InputProperty.RequiredDistribution probeRequiredDistribution = (InputProperty.RequiredDistribution)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)buildRequiredDistribution, (Object)probeRequiredDistribution);
        Tuple2 tuple24 = tuple23;
        InputProperty.RequiredDistribution buildRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple24._1();
        InputProperty.RequiredDistribution probeRequiredDistribution2 = (InputProperty.RequiredDistribution)tuple24._2();
        InputProperty buildInputProperty = InputProperty.builder().requiredDistribution(buildRequiredDistribution2).damBehavior(InputProperty.DamBehavior.BLOCKING).priority(0).build();
        InputProperty probeInputProperty = InputProperty.builder().requiredDistribution(probeRequiredDistribution2).damBehavior(InputProperty.DamBehavior.PIPELINED).priority(1).build();
        return this.leftIsBuild() ? new Tuple2((Object)buildInputProperty, (Object)probeInputProperty) : new Tuple2((Object)probeInputProperty, (Object)buildInputProperty);
    }

    public BatchPhysicalNestedLoopJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftIsBuild, boolean singleRowJoin) {
        this.cluster = cluster;
        this.condition = condition;
        this.joinType = joinType;
        this.leftIsBuild = leftIsBuild;
        this.singleRowJoin = singleRowJoin;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
    }
}

