/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.calls.MethodCallGen;
import org.apache.flink.table.planner.codegen.calls.MethodCallGen$;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.utils.DateTimeUtils;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0002\u0004\u0001+!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u0003*\u0001\u0011\u0005#\u0006C\u0003O\u0001\u0011%qJ\u0001\bFqR\u0014\u0018m\u0019;DC2dw)\u001a8\u000b\u0005\u001dA\u0011!B2bY2\u001c(BA\u0005\u000b\u0003\u001d\u0019w\u000eZ3hK:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u0007\u0013\tIbAA\u0007NKRDw\u000eZ\"bY2<UM\\\u0001\u0007[\u0016$\bn\u001c3\u0011\u0005q\u0019S\"A\u000f\u000b\u0005yy\u0012a\u0002:fM2,7\r\u001e\u0006\u0003A\u0005\nA\u0001\\1oO*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013\u001e\u0005\u0019iU\r\u001e5pI\u00061A(\u001b8jiz\"\"a\n\u0015\u0011\u0005]\u0001\u0001\"\u0002\u000e\u0003\u0001\u0004Y\u0012\u0001C4f]\u0016\u0014\u0018\r^3\u0015\t-zC\u0007\u0012\t\u0003Y5j\u0011\u0001C\u0005\u0003]!\u00111cR3oKJ\fG/\u001a3FqB\u0014Xm]:j_:DQ\u0001M\u0002A\u0002E\n1a\u0019;y!\ta#'\u0003\u00024\u0011\t!2i\u001c3f\u000f\u0016tWM]1u_J\u001cuN\u001c;fqRDQ!N\u0002A\u0002Y\n\u0001b\u001c9fe\u0006tGm\u001d\t\u0004o\u0005[cB\u0001\u001d?\u001d\tID(D\u0001;\u0015\tYD#\u0001\u0004=e>|GOP\u0005\u0002{\u0005)1oY1mC&\u0011q\bQ\u0001\ba\u0006\u001c7.Y4f\u0015\u0005i\u0014B\u0001\"D\u0005\r\u0019V-\u001d\u0006\u0003\u007f\u0001CQ!R\u0002A\u0002\u0019\u000b!B]3ukJtG+\u001f9f!\t9E*D\u0001I\u0015\tI%*A\u0004m_\u001eL7-\u00197\u000b\u0005-c\u0011!\u0002;za\u0016\u001c\u0018BA'I\u0005-aunZ5dC2$\u0016\u0010]3\u0002\u0013\u001d,GOR1di>\u0014HC\u0001)U!\t\t&+D\u0001A\u0013\t\u0019\u0006I\u0001\u0003M_:<\u0007\"B+\u0005\u0001\u00041\u0016\u0001B;oSR\u0004\"a\u00164\u000f\u0005a\u001bgBA-b\u001d\tQ\u0006M\u0004\u0002\\?:\u0011AL\u0018\b\u0003suK\u0011aE\u0005\u0003#II!a\u0004\t\n\u00055q\u0011B\u00012\r\u0003\u0015)H/\u001b7t\u0013\t!W-A\u0007ECR,G+[7f+RLGn\u001d\u0006\u0003E2I!a\u001a5\u0003\u0011QKW.Z+oSRT!\u0001Z3")
public class ExtractCallGen
extends MethodCallGen {
    private final Method method;

    @Override
    public GeneratedExpression generate(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType) {
        DateTimeUtils.TimeUnit unit = ((DateTimeUtils.TimeUnitRange)CodeGenUtils$.MODULE$.getEnum((GeneratedExpression)((GeneratedExpression)operands.head()))).startUnit;
        LogicalType tpe = ((GeneratedExpression)operands.apply(1)).resultType();
        DateTimeUtils.TimeUnit timeUnit = unit;
        if (DateTimeUtils.TimeUnit.YEAR.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.MONTH.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.DAY.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.QUARTER.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.DOY.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.ISOYEAR.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.DOW.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.ISODOW.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.WEEK.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.DECADE.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.CENTURY.equals(timeUnit) ? true : DateTimeUtils.TimeUnit.MILLENNIUM.equals(timeUnit)))))))))))) {
            LogicalTypeRoot logicalTypeRoot = tpe.getTypeRoot();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, operands, GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$4(), GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$5(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)terms -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(90).append("\n                   |").append(CodeGenUtils$.MODULE$.qualifyMethod($this.method)).append("(").append(terms.head()).append(",\n                   |    ").append(terms.apply(1)).append(".getMillisecond() / ").append(DateTimeUtils.TimeUnit.DAY.multiplier.intValue()).append(")\n                   |").toString())).stripMargin());
            }
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                return super.generate(ctx, operands, returnType);
            }
            if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                throw new ValidationException(new StringBuilder(41).append("unit ").append(unit).append(" can not be applied to time variable").toString());
            }
        } else if (DateTimeUtils.TimeUnit.EPOCH.equals(timeUnit)) {
            LogicalTypeRoot logicalTypeRoot = tpe.getTypeRoot();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, operands, GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$4(), GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$5(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)terms -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n                   |").append(terms.apply(1)).append(".getMillisecond() / ").append(DateTimeUtils.TimeUnit.SECOND.multiplier.intValue()).append("\n                   |").toString())).stripMargin());
            }
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                return super.generate(ctx, operands, returnType);
            }
            if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                throw new ValidationException(new StringBuilder(41).append("unit ").append(unit).append(" can not be applied to time variable").toString());
            }
        }
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, operands, GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$4(), GenerateUtils$.MODULE$.generateCallIfArgsNotNull$default$5(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)terms -> {
            long factor = this.getFactor(unit);
            LogicalTypeRoot logicalTypeRoot = tpe.getTypeRoot();
            String longTerm = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? new StringBuilder(17).append(terms.apply(1)).append(".getMillisecond()").toString() : String.valueOf(terms.apply(1));
            DateTimeUtils.TimeUnit timeUnit = unit;
            if (DateTimeUtils.TimeUnit.QUARTER.equals(timeUnit)) {
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(56).append("\n                 |((").append(longTerm).append(" % ").append(factor).append(") - 1) / ").append(unit$1.multiplier.intValue()).append(" + 1\n                 |").toString())).stripMargin();
            }
            if (DateTimeUtils.TimeUnit.MICROSECOND.equals(timeUnit)) {
                LogicalTypeRoot logicalTypeRoot2 = tpe.getTypeRoot();
                if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot2)) {
                    String nanoOfMilliTerm = new StringBuilder(23).append(terms.apply(1)).append(".getNanoOfMillisecond()").toString();
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n                     |(").append(longTerm).append(" % ").append(factor).append(") * 1000 + ").append(nanoOfMilliTerm).append(" / 1000\n                 ").toString())).stripMargin();
                }
                throw new ValidationException(new StringBuilder(37).append("unit ").append(unit).append(" can not be applied to ").append(tpe.toString()).append(" variable").toString());
            }
            if (DateTimeUtils.TimeUnit.NANOSECOND.equals(timeUnit)) {
                LogicalTypeRoot logicalTypeRoot3 = tpe.getTypeRoot();
                if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot3)) {
                    String nanoOfMilliTerm = new StringBuilder(23).append(terms.apply(1)).append(".getNanoOfMillisecond()").toString();
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n                     |(").append(longTerm).append(" % ").append(factor).append(") * 1000000 + ").append(nanoOfMilliTerm).append("\n                 ").toString())).stripMargin();
                }
                throw new ValidationException(new StringBuilder(37).append("unit ").append(unit).append(" can not be applied to ").append(tpe.toString()).append(" variable").toString());
            }
            if (factor == 1L) {
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(45).append("\n                   |").append(longTerm).append(" / ").append(unit$1.multiplier.intValue()).append("\n                   |").toString())).stripMargin();
            }
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n                   |(").append(longTerm).append(" % ").append(factor).append(") / ").append(unit$1.multiplier.intValue()).append("\n                   |").toString())).stripMargin();
        });
    }

    private long getFactor(DateTimeUtils.TimeUnit unit) {
        DateTimeUtils.TimeUnit timeUnit = unit;
        if (DateTimeUtils.TimeUnit.DAY.equals(timeUnit)) {
            return 1L;
        }
        if (DateTimeUtils.TimeUnit.HOUR.equals(timeUnit)) {
            return DateTimeUtils.TimeUnit.DAY.multiplier.longValue();
        }
        if (DateTimeUtils.TimeUnit.MINUTE.equals(timeUnit)) {
            return DateTimeUtils.TimeUnit.HOUR.multiplier.longValue();
        }
        if (DateTimeUtils.TimeUnit.SECOND.equals(timeUnit)) {
            return DateTimeUtils.TimeUnit.MINUTE.multiplier.longValue();
        }
        if (DateTimeUtils.TimeUnit.MILLISECOND.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.MICROSECOND.equals(timeUnit) ? true : DateTimeUtils.TimeUnit.NANOSECOND.equals(timeUnit))) {
            return DateTimeUtils.TimeUnit.SECOND.multiplier.longValue();
        }
        if (DateTimeUtils.TimeUnit.MONTH.equals(timeUnit)) {
            return DateTimeUtils.TimeUnit.YEAR.multiplier.longValue();
        }
        if (DateTimeUtils.TimeUnit.QUARTER.equals(timeUnit)) {
            return DateTimeUtils.TimeUnit.YEAR.multiplier.longValue();
        }
        if (DateTimeUtils.TimeUnit.YEAR.equals(timeUnit) ? true : (DateTimeUtils.TimeUnit.CENTURY.equals(timeUnit) ? true : DateTimeUtils.TimeUnit.MILLENNIUM.equals(timeUnit))) {
            return 1L;
        }
        throw new CodeGenException(new StringBuilder(25).append("Unit '").append(unit).append("' is not supported.").toString());
    }

    public ExtractCallGen(Method method) {
        this.method = method;
        super(method, MethodCallGen$.MODULE$.$lessinit$greater$default$2(), MethodCallGen$.MODULE$.$lessinit$greater$default$3());
    }
}

