/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableSet;

public class FlinkSemiAntiJoinFilterTransposeRule
extends RelOptRule {
    public static final FlinkSemiAntiJoinFilterTransposeRule INSTANCE = new FlinkSemiAntiJoinFilterTransposeRule(RelFactories.LOGICAL_BUILDER);

    public FlinkSemiAntiJoinFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(FlinkSemiAntiJoinFilterTransposeRule.operand(LogicalJoin.class, FlinkSemiAntiJoinFilterTransposeRule.some(FlinkSemiAntiJoinFilterTransposeRule.operand(LogicalFilter.class, FlinkSemiAntiJoinFilterTransposeRule.any()), new RelOptRuleOperand[0])), relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        return join.getJoinType() == JoinRelType.SEMI || join.getJoinType() == JoinRelType.ANTI;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        LogicalFilter filter = (LogicalFilter)call.rel(1);
        LogicalJoin newJoin = LogicalJoin.create(filter.getInput(), join.getRight(), join.getHints(), join.getCondition(), join.getVariablesSet(), join.getJoinType());
        RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
        RelNode newFilter = factory.createFilter(newJoin, filter.getCondition(), (Set<CorrelationId>)ImmutableSet.of());
        call.transformTo(newFilter);
    }
}

