/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors;

import java.time.ZoneId;
import java.util.ArrayList;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.buffers.AsyncStateWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors.AbstractAsyncStateWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.async.tvf.common.AsyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.async.tvf.slicing.AsyncStateSlicingWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SlicingWindowTimerServiceImpl;
import org.apache.flink.table.runtime.util.AsyncStateUtils;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncStateSliceWindowAggProcessor
extends AbstractAsyncStateWindowAggProcessor<Long>
implements AsyncStateSlicingWindowProcessor<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsyncStateSliceWindowAggProcessor.class);
    protected final AsyncStateWindowBuffer.Factory windowBufferFactory;
    protected final SliceAssigner sliceAssigner;
    protected final long windowInterval;
    private transient long nextTriggerProgress;
    protected transient AsyncStateWindowBuffer windowBuffer;

    public AbstractAsyncStateSliceWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, AsyncStateWindowBuffer.Factory bufferFactory, SliceAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, int indexOfCountStar, ZoneId shiftTimeZone) {
        super(genAggsHandler, sliceAssigner, accSerializer, sliceAssigner.isEventTime(), indexOfCountStar, shiftTimeZone, Long.MIN_VALUE);
        this.windowBufferFactory = bufferFactory;
        this.sliceAssigner = sliceAssigner;
        this.windowInterval = sliceAssigner.getSliceEndInterval();
    }

    @Override
    public void open(AsyncStateWindowProcessor.AsyncStateContext<Long> context) throws Exception {
        super.open(context);
        LOG.info("Slice window agg is using async state");
        this.windowBuffer = this.windowBufferFactory.create(((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getOperatorOwner(), ((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getMemoryManager(), ((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getMemorySize(), ((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getRuntimeContext(), this.windowTimerService, ((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getAsyncKeyContext(), this.windowState, this.isEventTime, this.shiftTimeZone);
        this.nextTriggerProgress = Long.MIN_VALUE;
    }

    @Override
    protected WindowTimerService<Long> getWindowTimerService() {
        return new SlicingWindowTimerServiceImpl((InternalTimerService<Long>)((AsyncStateWindowProcessor.AsyncStateContext)this.ctx).getTimerService(), this.shiftTimeZone);
    }

    @Override
    public StateFuture<Boolean> processElement(RowData key, RowData element) throws Exception {
        long sliceEnd = this.sliceAssigner.assignSliceEnd(element, this.clockService);
        if (!this.isEventTime) {
            this.windowTimerService.registerProcessingTimeWindowTimer(sliceEnd);
        }
        if (this.isEventTime && TimeWindowUtil.isWindowFired(sliceEnd, this.currentProgress, this.shiftTimeZone)) {
            long lastWindowEnd = this.sliceAssigner.getLastWindowEnd(sliceEnd);
            if (TimeWindowUtil.isWindowFired(lastWindowEnd, this.currentProgress, this.shiftTimeZone)) {
                return AsyncStateUtils.REUSABLE_TRUE_STATE_FUTURE;
            }
            StateFuture addElementFuture = this.sliceStateMergeTarget(sliceEnd).thenCompose(targetStateWindow -> this.windowBuffer.addElement(key, (long)targetStateWindow, element));
            long unfiredFirstWindow = sliceEnd;
            while (TimeWindowUtil.isWindowFired(unfiredFirstWindow, this.currentProgress, this.shiftTimeZone)) {
                unfiredFirstWindow += this.windowInterval;
            }
            this.windowTimerService.registerEventTimeWindowTimer(unfiredFirstWindow);
            return addElementFuture.thenApply(VOID -> false);
        }
        return this.windowBuffer.addElement(key, sliceEnd, element).thenApply(VOID -> false);
    }

    protected abstract StateFuture<Long> sliceStateMergeTarget(long var1) throws Exception;

    @Override
    public StateFuture<Void> advanceProgress(RowData currentKey, long progress) throws Exception {
        StateFuture<Void> advanceFuture = AsyncStateUtils.REUSABLE_VOID_STATE_FUTURE;
        if (progress > this.currentProgress) {
            this.currentProgress = progress;
            if (this.currentProgress >= this.nextTriggerProgress) {
                advanceFuture = this.windowBuffer.advanceProgress(currentKey, this.currentProgress);
                this.nextTriggerProgress = TimeWindowUtil.getNextTriggerWatermark(this.currentProgress, this.windowInterval, this.shiftTimeZone, this.useDayLightSaving);
            }
        }
        return advanceFuture;
    }

    @Override
    public StateFuture<Void> prepareCheckpoint() throws Exception {
        return this.windowBuffer.flush(null);
    }

    @Override
    public StateFuture<Void> clearWindow(long timerTimestamp, Long windowEnd) throws Exception {
        Iterable<Long> expires = this.sliceAssigner.expiredSlices(windowEnd);
        ArrayList<StateFuture<Void>> allClearFutures = new ArrayList<StateFuture<Void>>();
        for (Long slice : expires) {
            allClearFutures.add(this.windowState.asyncClear(slice));
            this.aggregator.cleanup(slice);
        }
        return StateFutureUtils.combineAll(allClearFutures).thenAccept(VOID -> {});
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.windowBuffer != null) {
            this.windowBuffer.close();
        }
    }

    @Override
    public TypeSerializer<Long> createWindowSerializer() {
        return LongSerializer.INSTANCE;
    }
}

