/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.CanonicalExtensionHeadersSerializer;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.SignedUrlEncodingHelper;
import com.google.cloud.storage.Storage;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class SignatureInfo {
    public static final char COMPONENT_SEPARATOR = '\n';
    public static final String GOOG4_RSA_SHA256 = "GOOG4-RSA-SHA256";
    public static final String SCOPE = "/auto/storage/goog4_request";
    private static final List<String> RESERVED_PARAMS_LOWER = ImmutableList.of("expires", "googleaccessid", "x-goog-algorithm", "x-goog-credential", "x-goog-date", "x-goog-expires", "x-goog-signedheaders");
    private final HttpMethod httpVerb;
    private final String contentMd5;
    private final String contentType;
    private final long expiration;
    private final Map<String, String> canonicalizedExtensionHeaders;
    private final Map<String, String> queryParams;
    private final URI canonicalizedResource;
    private final Storage.SignUrlOption.SignatureVersion signatureVersion;
    private final String accountEmail;
    private final long timestamp;
    private final String yearMonthDay;
    private final String exactDate;

    private SignatureInfo(Builder builder) {
        this.httpVerb = builder.httpVerb;
        this.contentMd5 = builder.contentMd5;
        this.contentType = builder.contentType;
        this.expiration = builder.expiration;
        this.canonicalizedResource = builder.canonicalizedResource;
        this.signatureVersion = builder.signatureVersion;
        this.accountEmail = builder.accountEmail;
        this.timestamp = builder.timestamp;
        ImmutableMap.Builder<String, String> headerBuilder = new ImmutableMap.Builder().putAll(builder.canonicalizedExtensionHeaders);
        if (Storage.SignUrlOption.SignatureVersion.V4.equals((Object)this.signatureVersion) && !builder.canonicalizedExtensionHeaders.containsKey("host")) {
            headerBuilder.put("host", "storage.googleapis.com");
        }
        this.canonicalizedExtensionHeaders = headerBuilder.build();
        this.queryParams = ImmutableMap.copyOf(builder.queryParams);
        Date date = new Date(this.timestamp);
        SimpleDateFormat yearMonthDayFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat exactDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        yearMonthDayFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        exactDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.yearMonthDay = yearMonthDayFormat.format(date);
        this.exactDate = exactDateFormat.format(date);
    }

    public String constructUnsignedPayload() {
        if (Storage.SignUrlOption.SignatureVersion.V4.equals((Object)this.signatureVersion)) {
            return this.constructV4UnsignedPayload();
        }
        return this.constructV2UnsignedPayload();
    }

    private String constructV2UnsignedPayload() {
        StringBuilder payload = new StringBuilder();
        payload.append(this.httpVerb.name()).append('\n');
        if (this.contentMd5 != null) {
            payload.append(this.contentMd5);
        }
        payload.append('\n');
        if (this.contentType != null) {
            payload.append(this.contentType);
        }
        payload.append('\n');
        payload.append(this.expiration).append('\n');
        if (this.canonicalizedExtensionHeaders.size() > 0) {
            payload.append((CharSequence)new CanonicalExtensionHeadersSerializer(Storage.SignUrlOption.SignatureVersion.V2).serialize(this.canonicalizedExtensionHeaders));
        }
        payload.append(this.canonicalizedResource);
        return payload.toString();
    }

    private String constructV4UnsignedPayload() {
        StringBuilder payload = new StringBuilder();
        payload.append(GOOG4_RSA_SHA256).append('\n');
        payload.append(this.exactDate).append('\n');
        payload.append(this.yearMonthDay).append(SCOPE).append('\n');
        payload.append(this.constructV4CanonicalRequestHash());
        return payload.toString();
    }

    private String constructV4CanonicalRequestHash() {
        StringBuilder canonicalRequest = new StringBuilder();
        CanonicalExtensionHeadersSerializer serializer = new CanonicalExtensionHeadersSerializer(Storage.SignUrlOption.SignatureVersion.V4);
        canonicalRequest.append(this.httpVerb.name()).append('\n');
        canonicalRequest.append(this.canonicalizedResource).append('\n');
        canonicalRequest.append(this.constructV4QueryString()).append('\n');
        canonicalRequest.append((CharSequence)serializer.serialize(this.canonicalizedExtensionHeaders)).append('\n');
        canonicalRequest.append((CharSequence)serializer.serializeHeaderNames(this.canonicalizedExtensionHeaders)).append('\n');
        String userProvidedHash = this.canonicalizedExtensionHeaders.get("X-Goog-Content-SHA256");
        canonicalRequest.append(userProvidedHash == null ? "UNSIGNED-PAYLOAD" : userProvidedHash);
        return Hashing.sha256().hashString(canonicalRequest.toString(), StandardCharsets.UTF_8).toString();
    }

    private TreeMap<String, String> getNonReservedUserQueryParams() {
        TreeMap<String, String> sortedParamMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            if (RESERVED_PARAMS_LOWER.contains(entry.getKey().toLowerCase())) continue;
            sortedParamMap.put(SignedUrlEncodingHelper.Rfc3986UriEncode(entry.getKey(), true), SignedUrlEncodingHelper.Rfc3986UriEncode(entry.getValue(), true));
        }
        return sortedParamMap;
    }

    private String queryStringFromParamMap(Map<String, String> map) {
        StringBuilder queryStringBuilder = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            queryStringBuilder.append(sep);
            sep = "&";
            queryStringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return queryStringBuilder.toString();
    }

    public String constructV2QueryString() {
        TreeMap<String, String> sortedParamMap = this.getNonReservedUserQueryParams();
        return this.queryStringFromParamMap(sortedParamMap);
    }

    public String constructV4QueryString() {
        TreeMap<String, String> sortedParamMap = this.getNonReservedUserQueryParams();
        sortedParamMap.put("X-Goog-Algorithm", SignedUrlEncodingHelper.Rfc3986UriEncode(GOOG4_RSA_SHA256, true));
        sortedParamMap.put("X-Goog-Credential", SignedUrlEncodingHelper.Rfc3986UriEncode(this.accountEmail + "/" + this.yearMonthDay + SCOPE, true));
        sortedParamMap.put("X-Goog-Date", SignedUrlEncodingHelper.Rfc3986UriEncode(this.exactDate, true));
        sortedParamMap.put("X-Goog-Expires", SignedUrlEncodingHelper.Rfc3986UriEncode(Long.toString(this.expiration), true));
        StringBuilder signedHeadersBuilder = new CanonicalExtensionHeadersSerializer(Storage.SignUrlOption.SignatureVersion.V4).serializeHeaderNames(this.canonicalizedExtensionHeaders);
        sortedParamMap.put("X-Goog-SignedHeaders", SignedUrlEncodingHelper.Rfc3986UriEncode(signedHeadersBuilder.toString(), true));
        return this.queryStringFromParamMap(sortedParamMap);
    }

    public HttpMethod getHttpVerb() {
        return this.httpVerb;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public Map<String, String> getCanonicalizedExtensionHeaders() {
        return this.canonicalizedExtensionHeaders;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public URI getCanonicalizedResource() {
        return this.canonicalizedResource;
    }

    public Storage.SignUrlOption.SignatureVersion getSignatureVersion() {
        return this.signatureVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getAccountEmail() {
        return this.accountEmail;
    }

    public static final class Builder {
        private final HttpMethod httpVerb;
        private String contentMd5;
        private String contentType;
        private final long expiration;
        private Map<String, String> canonicalizedExtensionHeaders;
        private Map<String, String> queryParams;
        private final URI canonicalizedResource;
        private Storage.SignUrlOption.SignatureVersion signatureVersion;
        private String accountEmail;
        private long timestamp;

        public Builder(HttpMethod httpVerb, long expiration, URI canonicalizedResource) {
            this.httpVerb = httpVerb;
            this.expiration = expiration;
            this.canonicalizedResource = canonicalizedResource;
        }

        public Builder(SignatureInfo signatureInfo) {
            this.httpVerb = signatureInfo.httpVerb;
            this.contentMd5 = signatureInfo.contentMd5;
            this.contentType = signatureInfo.contentType;
            this.expiration = signatureInfo.expiration;
            this.canonicalizedExtensionHeaders = signatureInfo.canonicalizedExtensionHeaders;
            this.queryParams = signatureInfo.queryParams;
            this.canonicalizedResource = signatureInfo.canonicalizedResource;
            this.signatureVersion = signatureInfo.signatureVersion;
            this.accountEmail = signatureInfo.accountEmail;
            this.timestamp = signatureInfo.timestamp;
        }

        public Builder setContentMd5(String contentMd5) {
            this.contentMd5 = contentMd5;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setCanonicalizedExtensionHeaders(Map<String, String> canonicalizedExtensionHeaders) {
            this.canonicalizedExtensionHeaders = canonicalizedExtensionHeaders;
            return this;
        }

        public Builder setCanonicalizedQueryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder setSignatureVersion(Storage.SignUrlOption.SignatureVersion signatureVersion) {
            this.signatureVersion = signatureVersion;
            return this;
        }

        public Builder setAccountEmail(String accountEmail) {
            this.accountEmail = accountEmail;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SignatureInfo build() {
            Preconditions.checkArgument(this.httpVerb != null, "Required HTTP method");
            Preconditions.checkArgument(this.canonicalizedResource != null, "Required canonicalized resource");
            Preconditions.checkArgument(this.expiration >= 0L, "Expiration must be greater than or equal to zero");
            if (Storage.SignUrlOption.SignatureVersion.V4.equals((Object)this.signatureVersion)) {
                Preconditions.checkArgument(this.accountEmail != null, "Account email required to use V4 signing");
                Preconditions.checkArgument(this.timestamp > 0L, "Timestamp required to use V4 signing");
                Preconditions.checkArgument(this.expiration <= 604800L, "Expiration can't be longer than 7 days to use V4 signing");
            }
            if (this.canonicalizedExtensionHeaders == null) {
                this.canonicalizedExtensionHeaders = new HashMap<String, String>();
            }
            if (this.queryParams == null) {
                this.queryParams = new HashMap<String, String>();
            }
            return new SignatureInfo(this);
        }
    }
}

